/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.util.FluidTooltipCallback;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeCategory
implements IRecipeCategory<AlloyRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/alloy.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "alloy.title");
    private static final Component CATALYST = TConstruct.makeTranslation("jei", "alloy.catalyst").m_130940_(ChatFormatting.ITALIC);
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final FluidTooltipCallback CATALYST_TOOLTIP = (fluid, slot, tooltip) -> {
        tooltip.add(CATALYST);
        FluidTooltipHandler.appendMaterial((FluidStack)fluid, (List)tooltip);
    };
    public static final FluidTooltipCallback FUEL_TOOLTIP = (fluid, slot, tooltip) -> {
        MeltingFuel fuel = MeltingFuelLookup.findFuel(fluid.getFluid());
        if (fuel != null) {
            tooltip.add(Component.m_237110_((String)KEY_TEMPERATURE, (Object[])new Object[]{fuel.getTemperature()}).m_130940_(ChatFormatting.GRAY));
        }
    };
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable tank;

    public AlloyRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 172, 62);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(TinkerSmeltery.smelteryController));
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 172, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 172, 17, 16, 16);
    }

    public RecipeType<AlloyRecipe> getRecipeType() {
        return TConstructJEIConstants.ALLOY;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void draw(AlloyRecipe recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 90, 21);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        String tempString = I18n.m_118938_((String)KEY_TEMPERATURE, (Object[])new Object[]{recipe.getTemperature()});
        int x = 102 - fontRenderer.m_92895_(tempString) / 2;
        graphics.m_280056_(fontRenderer, tempString, x, 5, Color.GRAY.getRGB(), false);
    }

    public static <T> int drawVariableFluids(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int x, int y, int totalWidth, int height, List<T> fluids, int minAmount, Function<T, List<FluidStack>> mapper, Function<T, IRecipeSlotTooltipCallback> tooltip) {
        int count = fluids.size();
        int maxAmount = minAmount;
        if (count > 0) {
            for (T ingredient : fluids) {
                for (FluidStack input : mapper.apply(ingredient)) {
                    if (input.getAmount() <= maxAmount) continue;
                    maxAmount = input.getAmount();
                }
            }
            int w = totalWidth / count;
            int max = count - 1;
            for (int i = 0; i < max; ++i) {
                int fluidX = x + i * w;
                T ingredient = fluids.get(i);
                builder.addSlot(role, fluidX, y).addTooltipCallback(tooltip.apply(ingredient)).setFluidRenderer((long)maxAmount, false, w, height).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, mapper.apply(ingredient));
            }
            int fluidX = x + max * w;
            T ingredient = fluids.get(max);
            builder.addSlot(role, fluidX, y).addTooltipCallback(tooltip.apply(ingredient)).setFluidRenderer((long)maxAmount, false, totalWidth - w * max, height).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, mapper.apply(ingredient));
        }
        return maxAmount;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyRecipe recipe, IFocusGroup focuses) {
        int maxAmount = AlloyRecipeCategory.drawVariableFluids(builder, RecipeIngredientRole.INPUT, 19, 11, 48, 32, recipe.getInputs(), recipe.getOutput().getAmount(), ingredient -> ingredient.fluid().getFluids(), ingredient -> ingredient.catalyst() ? CATALYST_TOOLTIP : FluidTooltipCallback.UNITS);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 11).addTooltipCallback((IRecipeSlotTooltipCallback)FluidTooltipCallback.UNITS).setFluidRenderer((long)maxAmount, false, 16, 32).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 94, 43).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1L, false, 16, 16).setOverlay(this.tank, 0, 0).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public ResourceLocation getRegistryName(AlloyRecipe recipe) {
        return recipe.m_6423_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

