/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class FluidParticle
extends TextureSheetParticle {
    private final FluidStack fluid;
    private final float uCoord;
    private final float vCoord;

    protected FluidParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, FluidStack fluid) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.fluid = fluid;
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        this.m_108337_(Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(attributes.getStillTexture(fluid)));
        this.f_107226_ = 1.0f;
        int color = attributes.getTintColor(fluid);
        this.f_107230_ = (float)(color >> 24 & 0xFF) / 255.0f;
        this.f_107227_ = (float)(color >> 16 & 0xFF) / 255.0f;
        this.f_107228_ = (float)(color >> 8 & 0xFF) / 255.0f;
        this.f_107229_ = (float)(color & 0xFF) / 255.0f;
        this.f_107663_ /= 2.0f;
        this.uCoord = this.f_107223_.m_188501_() * 3.0f;
        this.vCoord = this.f_107223_.m_188501_() * 3.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uCoord + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uCoord / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vCoord / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vCoord + 1.0f) / 4.0f * 16.0f));
    }

    public int m_6355_(float partialTick) {
        return FluidRenderer.withBlockLight((int)super.m_6355_(partialTick), (int)this.fluid.getFluid().getFluidType().getLightLevel(this.fluid));
    }

    public static class Factory
    implements ParticleProvider<FluidParticleData> {
        public Particle createParticle(FluidParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FluidStack fluid = data.getFluid();
            return !fluid.isEmpty() ? new FluidParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, fluid) : null;
        }
    }
}

