/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.events.teleport.ReturningTeleportEvent;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.TeleportHelper;

public class ReturningEffect
extends TinkerEffect {
    private static final ResourceLocation KEY = new ResourceLocation("tconstruct:returning");

    public ReturningEffect() {
        super(MobEffectCategory.NEUTRAL, 11087359, true);
        MinecraftForge.EVENT_BUS.addListener(this::onEffectAdded);
    }

    private void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_() && event.getOldEffectInstance() == null && event.getEffectInstance().m_19544_() == this) {
            ModDataNBT data = PersistentDataCapability.getOrWarn((Entity)entity);
            CompoundTag pos = NbtUtils.m_129224_((BlockPos)entity.m_20183_());
            pos.m_128359_("dimension", entity.m_9236_().m_46472_().m_135782_().toString());
            data.put(KEY, (Tag)pos);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration == 1;
    }

    public void m_6742_(LivingEntity living, int amplifier) {
        CompoundTag tag;
        ResourceLocation dimension;
        ModDataNBT data = PersistentDataCapability.getOrWarn((Entity)living);
        if (data.contains(KEY, 10) && (dimension = ResourceLocation.m_135820_((String)(tag = data.getCompound(KEY)).m_128461_("dimension"))) != null && dimension.equals((Object)living.m_9236_().m_46472_().m_135782_())) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag);
            TeleportHelper.tryTeleport(new ReturningTeleportEvent(living, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        }
    }
}

