/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.vesseldetector;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.block.vesseldetector.VesselDetectorTileEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import dev.murad.shipping.util.MathUtil;
import dev.murad.shipping.util.TickerUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class VesselDetectorBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final DustParticleOptions PARTICLE = new DustParticleOptions(new Vector3f(0.9f, 0.65f, 0.2f), 1.0f);

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModTileEntitiesTypes.VESSEL_DETECTOR.get()).m_155264_(pos, state);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return state.m_61143_((Property)FACING) == side;
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos blockPos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && direction == state.m_61143_((Property)FACING) ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter reader, BlockPos blockPos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && direction == state.m_61143_((Property)FACING) ? 15 : 0;
    }

    public VesselDetectorBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    private void showParticles(BlockPos pos, BlockState state, Level level) {
        AABB bb = VesselDetectorTileEntity.getSearchBox(pos, (Direction)state.m_61143_((Property)FACING), level);
        List<Pair<Vec3, Vec3>> edges = MathUtil.getEdges(bb);
        for (Pair<Vec3, Vec3> edge : edges) {
            Vec3 from = (Vec3)edge.getFirst();
            Vec3 to = (Vec3)edge.getSecond();
            for (int i = 0; i < 10; ++i) {
                Vec3 pPos = MathUtil.lerp(from, to, (float)i / 10.0f);
                level.m_7106_((ParticleOptions)PARTICLE, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            this.showParticles(pos, state, entity.m_9236_());
        }
        return InteractionResult.SUCCESS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : TickerUtil.createTickerHelper(type, (BlockEntityType)ModTileEntitiesTypes.VESSEL_DETECTOR.get(), VesselDetectorTileEntity::serverTick);
    }
}

