/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.data.client;

import dev.murad.shipping.block.dock.DockingBlockStates;
import dev.murad.shipping.block.energy.VesselChargerBlock;
import dev.murad.shipping.block.fluid.FluidHopperBlock;
import dev.murad.shipping.block.guiderail.CornerGuideRailBlock;
import dev.murad.shipping.block.rail.AbstractDockingRail;
import dev.murad.shipping.block.rail.SwitchRail;
import dev.murad.shipping.block.vesseldetector.VesselDetectorBlock;
import dev.murad.shipping.setup.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "littlelogistics", exFileHelper);
    }

    public static ResourceLocation getBlTx(String name) {
        return new ResourceLocation("littlelogistics", String.format("block/%s", name));
    }

    private ModelFile getTugDockModel(BlockState state) {
        String inv = (Boolean)state.m_61143_((Property)DockingBlockStates.INVERTED) != false ? "_inv" : "";
        String powered = (Boolean)state.m_61143_((Property)DockingBlockStates.POWERED) != false ? "_powered" : "";
        return this.models().orientable("tug_dock" + inv + powered, ModBlockStateProvider.getBlTx("tug_dock"), ModBlockStateProvider.getBlTx("tug_dock_front" + powered), ModBlockStateProvider.getBlTx("tug_dock_top" + inv));
    }

    private ModelFile getCornerGuideRailModel(BlockState state) {
        String inv = (Boolean)state.m_61143_((Property)CornerGuideRailBlock.INVERTED) != false ? "_inv" : "";
        return this.models().orientable("guide_rail_corner" + inv, ModBlockStateProvider.getBlTx("guide_rail_side"), ModBlockStateProvider.getBlTx("guide_rail_front" + inv), ModBlockStateProvider.getBlTx("guide_rail_top" + inv));
    }

    private ModelFile getTugGuideRailModel(BlockState state) {
        return this.models().orientable("guide_rail_tug", ModBlockStateProvider.getBlTx("guide_rail_side"), ModBlockStateProvider.getBlTx("guide_rail_side"), ModBlockStateProvider.getBlTx("guide_rail_front"));
    }

    private ModelFile getVesselDetectorModel(BlockState state) {
        String powered = (Boolean)state.m_61143_((Property)VesselDetectorBlock.POWERED) != false ? "_powered" : "";
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("vessel_detector" + powered, this.modLoc("orientable_with_back"))).texture("side", ModBlockStateProvider.getBlTx("vessel_detector_side"))).texture("front", ModBlockStateProvider.getBlTx("vessel_detector_front"))).texture("back", ModBlockStateProvider.getBlTx("vessel_detector_back" + powered));
    }

    private ModelFile getBargeDockModel(BlockState state) {
        String inv = (Boolean)state.m_61143_((Property)DockingBlockStates.INVERTED) != false ? "_extract" : "";
        return this.models().orientable("barge_dock" + inv, ModBlockStateProvider.getBlTx("barge_dock"), ModBlockStateProvider.getBlTx("barge_dock_front" + inv), ModBlockStateProvider.getBlTx("barge_dock_top"));
    }

    private int xRotFromDir(Direction direction) {
        switch (direction) {
            case DOWN: {
                return 270;
            }
            case UP: {
                return 90;
            }
        }
        return 0;
    }

    protected void registerStatesAndModels() {
        this.getVariantBuilder((Block)ModBlocks.TUG_DOCK.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTugDockModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)DockingBlockStates.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.BARGE_DOCK.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getBargeDockModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)DockingBlockStates.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.GUIDE_RAIL_CORNER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getCornerGuideRailModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)CornerGuideRailBlock.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.VESSEL_DETECTOR.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getVesselDetectorModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)VesselDetectorBlock.FACING)).m_122424_().m_122435_()).rotationX(this.xRotFromDir(((Direction)state.m_61143_((Property)VesselDetectorBlock.FACING)).m_122424_())).build());
        this.getVariantBuilder((Block)ModBlocks.GUIDE_RAIL_TUG.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTugGuideRailModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)CornerGuideRailBlock.FACING)).m_122427_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.FLUID_HOPPER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().withExistingParent("fluid_hopper", this.modLoc("fluid_hopper_parent_model"))).rotationY((int)((Direction)state.m_61143_((Property)FluidHopperBlock.FACING)).m_122427_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.VESSEL_CHARGER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().withExistingParent("vessel_charger", this.modLoc("vessel_charger_parent_model"))).rotationY((int)((Direction)state.m_61143_((Property)VesselChargerBlock.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.SWITCH_RAIL.get()).forAllStates(state -> {
            String outDir = ((SwitchRail.OutDirection)((Object)((Object)state.m_61143_(SwitchRail.OUT_DIRECTION)))).m_7912_();
            String powered = (Boolean)state.m_61143_((Property)SwitchRail.POWERED) != false ? "on" : "off";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("switch_rail_" + outDir + "_" + powered, this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("switch_rail_" + outDir + "_" + powered))).rotationY((int)((Direction)state.m_61143_(SwitchRail.FACING)).m_122424_().m_122435_()).build();
        });
        this.getVariantBuilder((Block)ModBlocks.AUTOMATIC_SWITCH_RAIL.get()).forAllStates(state -> {
            String outDir = ((SwitchRail.OutDirection)((Object)((Object)state.m_61143_(SwitchRail.OUT_DIRECTION)))).m_7912_();
            String powered = (Boolean)state.m_61143_((Property)SwitchRail.POWERED) != false ? "on" : "off";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("automatic_switch_rail_" + outDir + "_" + powered, this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("automatic_switch_rail_" + outDir + "_" + powered))).rotationY((int)((Direction)state.m_61143_(SwitchRail.FACING)).m_122424_().m_122435_()).build();
        });
        this.getVariantBuilder((Block)ModBlocks.TEE_JUNCTION_RAIL.get()).forAllStates(state -> {
            String powered = (Boolean)state.m_61143_((Property)SwitchRail.POWERED) != false ? "on" : "off";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("tee_junction_rail_" + powered, this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("tee_junction_rail_" + powered))).rotationY((int)((Direction)state.m_61143_(SwitchRail.FACING)).m_122424_().m_122435_()).build();
        });
        this.getVariantBuilder((Block)ModBlocks.AUTOMATIC_TEE_JUNCTION_RAIL.get()).forAllStates(state -> {
            String powered = (Boolean)state.m_61143_((Property)SwitchRail.POWERED) != false ? "on" : "off";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("automatic_tee_junction_rail_" + powered, this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("automatic_tee_junction_rail_" + powered))).rotationY((int)((Direction)state.m_61143_(SwitchRail.FACING)).m_122424_().m_122435_()).build();
        });
        this.getVariantBuilder((Block)ModBlocks.JUNCTION_RAIL.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("junction_rail", this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("junction_rail"))).build());
        this.getVariantBuilder((Block)ModBlocks.CAR_DOCK_RAIL.get()).forAllStates(state -> {
            String inv = (Boolean)state.m_61143_((Property)DockingBlockStates.INVERTED) != false ? "_extract" : "";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("car_dock_rail" + inv, this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("car_dock_rail" + inv))).rotationY(((RailShape)state.m_61143_(AbstractDockingRail.RAIL_SHAPE)).equals((Object)RailShape.NORTH_SOUTH) ? 0 : 90).build();
        });
        this.getVariantBuilder((Block)ModBlocks.LOCOMOTIVE_DOCK_RAIL.get()).forAllStates(state -> {
            String powered = (Boolean)state.m_61143_((Property)DockingBlockStates.POWERED) != false ? "_powered" : "";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("locomotive_dock_rail" + powered, this.mcLoc("rail_flat"))).texture("rail", ModBlockStateProvider.getBlTx("locomotive_dock_rail" + powered))).rotationY((int)((Direction)state.m_61143_((Property)DockingBlockStates.FACING)).m_122424_().m_122435_()).build();
        });
        this.getVariantBuilder((Block)ModBlocks.RAPID_HOPPER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.getRapidHopperModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)HopperBlock.f_54021_)).m_122424_().m_122435_()).build());
    }

    private BlockModelBuilder getRapidHopperModel(BlockState state) {
        String side = ((Direction)state.m_61143_((Property)HopperBlock.f_54021_)).equals((Object)Direction.DOWN) ? "" : "_side";
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("rapid_hopper" + side, this.mcLoc("hopper" + side))).texture("particle", ModBlockStateProvider.getBlTx("rapid_hopper_outside"))).texture("top", ModBlockStateProvider.getBlTx("rapid_hopper_top"))).texture("side", ModBlockStateProvider.getBlTx("rapid_hopper_outside"))).texture("inside", ModBlockStateProvider.getBlTx("rapid_hopper_inside"));
    }
}

