/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.barge;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.custom.TrainInventoryProvider;
import dev.murad.shipping.entity.custom.vessel.barge.AbstractBargeEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import dev.murad.shipping.util.LinkableEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FishingBargeEntity
extends AbstractBargeEntity {
    private int ticksDeployable = 0;
    private int fishCooldown = 0;
    private final Set<Pair<Integer, Integer>> overFishedCoords = new HashSet<Pair<Integer, Integer>>();
    private final Queue<Pair<Integer, Integer>> overFishedQueue = new LinkedList<Pair<Integer, Integer>>();
    private static final ResourceLocation FISHING_LOOT_TABLE = new ResourceLocation((String)ShippingConfig.Server.FISHING_LOOT_TABLE.get());
    private static final int FISHING_COOLDOWN = (Integer)ShippingConfig.Server.FISHING_COOLDOWN.get();
    private static final double FISHING_TREASURE_CHANCE = (Double)ShippingConfig.Server.FISHING_TREASURE_CHANCE_MODIFIER.get();

    public FishingBargeEntity(EntityType<? extends FishingBargeEntity> type, Level world) {
        super((EntityType<? extends AbstractBargeEntity>)type, world);
    }

    public FishingBargeEntity(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.FISHING_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    protected void doInteract(Player player) {
        int size = this.getConnectedInventories().size();
        player.m_5661_((Component)(switch (size) {
            case 0 -> Component.m_237115_((String)"global.littlelogistics.no_connected_inventory_barge");
            default -> Component.m_237110_((String)"global.littlelogistics.connected_inventory", (Object[])new Object[]{size});
        }), false);
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        super.m_142687_(r);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickWaterOnSidesCheck();
        if (!this.m_9236_().f_46443_ && this.getStatus() == Status.DEPLOYED) {
            if (this.fishCooldown < 0) {
                this.tickFish();
                this.fishCooldown = FISHING_COOLDOWN;
            } else {
                --this.fishCooldown;
            }
        }
    }

    private void tickWaterOnSidesCheck() {
        this.ticksDeployable = this.hasWaterOnSides() ? ++this.ticksDeployable : 0;
    }

    private double computeDepthPenalty() {
        int count = 0;
        BlockPos pos = this.m_20097_();
        while (this.m_9236_().m_8055_(pos).m_60734_().equals(Blocks.f_49990_)) {
            ++count;
            pos = pos.m_7495_();
        }
        count = Math.min(count, 20);
        return (double)count / 20.0;
    }

    private void tickFish() {
        double overFishPenalty = this.isOverFished() ? 0.05 : 1.0;
        double shallowPenalty = this.computeDepthPenalty();
        double chance = 0.25 * overFishPenalty * shallowPenalty;
        double treasure_chance = shallowPenalty > 0.4 ? chance * (shallowPenalty / 2.0) * FISHING_TREASURE_CHANCE : 0.0;
        double r = Math.random();
        if (r < chance) {
            LootParams params = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42523_)).m_287286_(LootContextParams.f_81458_, (Object)this).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81414_);
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(r < treasure_chance ? BuiltInLootTables.f_78722_ : FISHING_LOOT_TABLE);
            ObjectArrayList list = loottable.m_287195_(params);
            List<TrainInventoryProvider> inventoryProviders = this.getConnectedInventories();
            Iterator iterator = list.iterator();
            block0: while (iterator.hasNext()) {
                ItemStack stack;
                ItemStack leftOver = stack = (ItemStack)iterator.next();
                for (TrainInventoryProvider provider : inventoryProviders) {
                    if (leftOver.m_41619_()) continue block0;
                    Optional<ItemStackHandler> itemHandler = provider.getTrainInventoryHandler();
                    if (!itemHandler.isPresent()) continue;
                    leftOver = InventoryUtils.moveItemStackIntoHandler(itemHandler.get(), leftOver);
                }
            }
            if (!this.isOverFished()) {
                this.addOverFish();
            }
        }
    }

    private String overFishedString() {
        return this.overFishedQueue.stream().map(t -> t.getFirst() + ":" + t.getSecond()).reduce("", (acc, curr) -> String.join((CharSequence)",", acc, curr));
    }

    private void populateOverfish(String string) {
        Arrays.stream(string.split(",")).filter(s -> !s.isEmpty()).map(s -> s.split(":")).map(arr -> new Pair((Object)Integer.parseInt(arr[0]), (Object)Integer.parseInt(arr[1]))).forEach(this.overFishedQueue::add);
        this.overFishedCoords.addAll(this.overFishedQueue);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128359_("overfish", this.overFishedString());
        super.m_7380_(compound);
    }

    private void addOverFish() {
        int x = (int)Math.floor(this.m_20185_());
        int z = (int)Math.floor(this.m_20189_());
        this.overFishedCoords.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)z));
        this.overFishedQueue.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)z));
        if (this.overFishedQueue.size() > 30) {
            this.overFishedCoords.remove(this.overFishedQueue.poll());
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        this.populateOverfish(compound.m_128461_("overfish"));
        super.m_7378_(compound);
    }

    private boolean isOverFished() {
        int x = (int)Math.floor(this.m_20185_());
        int z = (int)Math.floor(this.m_20189_());
        return this.overFishedCoords.contains(new Pair((Object)x, (Object)z));
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.FISHING_BARGE.get();
    }

    public Status getStatus() {
        return this.hasWaterOnSides() ? this.getNonStashedStatus() : Status.STASHED;
    }

    private Status getNonStashedStatus() {
        if (this.ticksDeployable < 40) {
            return Status.TRANSITION;
        }
        return this.applyWithDominant(LinkableEntity::hasWaterOnSides).reduce(true, Boolean::logicalAnd) != false ? Status.DEPLOYED : Status.TRANSITION;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    public static enum Status {
        STASHED,
        DEPLOYED,
        TRANSITION;

    }
}

