/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryUtils {
    public static boolean mayMoveIntoInventory(Container target, Container source) {
        ItemStack stack;
        int i;
        if (source.m_7983_()) {
            return false;
        }
        HashMap<Item, ArrayList<ItemStack>> map = new HashMap<Item, ArrayList<ItemStack>>();
        ArrayList<Integer> airList = new ArrayList<Integer>();
        for (i = 0; i < target.m_6643_(); ++i) {
            stack = target.m_8020_(i);
            if ((stack.m_41619_() || stack.m_41720_().equals(Items.f_41852_)) && target.m_7013_(i, stack)) {
                airList.add(i);
                continue;
            }
            if (stack.m_41741_() == stack.m_41613_() || !target.m_7013_(i, stack)) continue;
            if (map.containsKey(stack.m_41720_())) {
                ((List)map.get(stack.m_41720_())).add(stack);
                continue;
            }
            map.put(stack.m_41720_(), new ArrayList<ItemStack>(Collections.singleton(stack)));
        }
        for (i = 0; i < source.m_6643_(); ++i) {
            Entity e;
            boolean validSlot;
            stack = source.m_8020_(i);
            if (!stack.m_41619_() && map.containsKey(stack.m_41720_())) {
                for (ItemStack targetStack : (List)map.get(stack.m_41720_())) {
                    if (!InventoryUtils.canMergeItems(targetStack, stack)) continue;
                    return true;
                }
                continue;
            }
            if (!(!airList.isEmpty() && target instanceof Entity ? (validSlot = (e = (Entity)target).getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> airList.stream().map(j -> itemHandler.isItemValid(j.intValue(), stack)).reduce(false, Boolean::logicalOr)).orElse(true).booleanValue()) : !airList.isEmpty())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(ItemStackHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).m_41619_() || itemHandler.getStackInSlot(i).m_41720_().equals(Items.f_41852_)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static ItemStack moveItemStackIntoHandler(ItemStackHandler handler, @NonNull ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots && !stack.m_41619_(); ++i) {
            stack = handler.insertItem(i, stack, false);
        }
        return stack;
    }

    public static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        if (stack1.m_41613_() > stack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    @Nullable
    public static IEnergyStorage getEnergyCapabilityInSlot(int slot, ItemStackHandler handler) {
        Optional capabilityOpt;
        LazyOptional capabilityLazyOpt;
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.m_41619_() && (capabilityLazyOpt = stack.getCapability(ForgeCapabilities.ENERGY)).isPresent() && (capabilityOpt = capabilityLazyOpt.resolve()).isPresent()) {
            return (IEnergyStorage)capabilityOpt.get();
        }
        return null;
    }
}

