/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DOStairBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NNN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_NNP = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NPN = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_NPP = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OCTET_PNN = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_PNP = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_PPN = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_PPP = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] TOP_SHAPES = DOStairBlock.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = DOStairBlock.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block base;
    private final BlockState baseState;
    private final Supplier<BlockState> stateSupplier;

    public DOStairBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.base = Blocks.f_50016_;
        this.baseState = Blocks.f_50016_.m_49966_();
        this.stateSupplier = state;
    }

    private static VoxelShape[] makeShapes(VoxelShape p_56934_, VoxelShape p_56935_, VoxelShape p_56936_, VoxelShape p_56937_, VoxelShape p_56938_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> DOStairBlock.makeStairShape(p_56945_, p_56934_, p_56935_, p_56936_, p_56937_, p_56938_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int p_56865_, VoxelShape p_56866_, VoxelShape p_56867_, VoxelShape p_56868_, VoxelShape p_56869_, VoxelShape p_56870_) {
        VoxelShape voxelshape = p_56866_;
        if ((p_56865_ & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)p_56866_, (VoxelShape)p_56867_);
        }
        if ((p_56865_ & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)p_56868_);
        }
        if ((p_56865_ & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)p_56869_);
        }
        if ((p_56865_ & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)p_56870_);
        }
        return voxelshape;
    }

    public boolean m_6724_(BlockState p_56947_) {
        return this.base.m_6724_(p_56947_);
    }

    public void m_214162_(BlockState p_222518_, Level p_222519_, BlockPos p_222520_, RandomSource p_222521_) {
        this.base.m_214162_(p_222518_, p_222519_, p_222520_, p_222521_);
    }

    public void m_6786_(LevelAccessor p_56882_, BlockPos p_56883_, BlockState p_56884_) {
        this.base.m_6786_(p_56882_, p_56883_, p_56884_);
    }

    public float m_7325_() {
        return this.base.m_7325_();
    }

    public void m_7592_(Level p_56878_, BlockPos p_56879_, Explosion p_56880_) {
        this.base.m_7592_(p_56878_, p_56879_, p_56880_);
    }

    public void m_141947_(Level p_154720_, BlockPos p_154721_, BlockState p_154722_, Entity p_154723_) {
        this.base.m_141947_(p_154720_, p_154721_, p_154722_, p_154723_);
    }

    public BlockState m_5573_(BlockPlaceContext p_56872_) {
        Direction direction = p_56872_.m_43719_();
        BlockPos blockpos = p_56872_.m_8083_();
        FluidState fluidstate = p_56872_.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_56872_.m_8125_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && p_56872_.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)this.getStairsShape(blockstate, (BlockGetter)p_56872_.m_43725_(), blockpos));
    }

    private StairsShape getStairsShape(BlockState p_56977_, BlockGetter p_56978_, BlockPos p_56979_) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)p_56977_.m_61143_((Property)FACING);
        BlockState blockstate = p_56978_.m_8055_(p_56979_.m_121945_(direction));
        if (this.isStairs(blockstate) && p_56977_.m_61143_(HALF) == blockstate.m_61143_(HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)p_56977_.m_61143_((Property)FACING)).m_122434_() && this.canTakeShape(p_56977_, p_56978_, p_56979_, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = p_56978_.m_8055_(p_56979_.m_121945_(direction.m_122424_()));
        if (this.isStairs(blockstate1) && p_56977_.m_61143_(HALF) == blockstate1.m_61143_(HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)p_56977_.m_61143_((Property)FACING)).m_122434_() && this.canTakeShape(p_56977_, p_56978_, p_56979_, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public boolean isStairs(BlockState p_56981_) {
        return p_56981_.m_60734_() instanceof DOStairBlock;
    }

    private boolean canTakeShape(BlockState p_56971_, BlockGetter p_56972_, BlockPos p_56973_, Direction p_56974_) {
        BlockState blockstate = p_56972_.m_8055_(p_56973_.m_121945_(p_56974_));
        return !this.isStairs(blockstate) || blockstate.m_61143_((Property)FACING) != p_56971_.m_61143_((Property)FACING) || blockstate.m_61143_(HALF) != p_56971_.m_61143_(HALF);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56932_) {
        p_56932_.m_61104_(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public boolean m_7357_(BlockState p_56891_, BlockGetter p_56892_, BlockPos p_56893_, PathComputationType p_56894_) {
        return false;
    }

    public BlockState m_7417_(BlockState p_56925_, Direction p_56926_, BlockState p_56927_, LevelAccessor p_56928_, BlockPos p_56929_, BlockPos p_56930_) {
        if (((Boolean)p_56925_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_56928_.m_186469_(p_56929_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_56928_));
        }
        return p_56926_.m_122434_().m_122479_() ? (BlockState)p_56925_.m_61124_(SHAPE, (Comparable)this.getStairsShape(p_56925_, (BlockGetter)p_56928_, p_56929_)) : super.m_7417_(p_56925_, p_56926_, p_56927_, p_56928_, p_56929_, p_56930_);
    }

    public void m_6807_(BlockState p_56961_, Level p_56962_, BlockPos p_56963_, BlockState p_56964_, boolean p_56965_) {
        if (!p_56961_.m_60713_(p_56961_.m_60734_())) {
            p_56962_.m_213960_(this.baseState, p_56963_, Blocks.f_50016_, p_56963_, false);
            this.base.m_6807_(this.baseState, p_56962_, p_56963_, p_56964_, false);
        }
    }

    public void m_6810_(BlockState p_56908_, Level p_56909_, BlockPos p_56910_, BlockState p_56911_, boolean p_56912_) {
        if (!p_56908_.m_60713_(p_56911_.m_60734_())) {
            this.baseState.m_60753_(p_56909_, p_56910_, p_56911_, p_56912_);
        }
    }

    public InteractionResult m_6227_(BlockState p_56901_, Level p_56902_, BlockPos p_56903_, Player p_56904_, InteractionHand p_56905_, BlockHitResult p_56906_) {
        return this.baseState.m_60664_(p_56902_, p_56904_, p_56905_, p_56906_);
    }

    public boolean m_7923_(BlockState p_56967_) {
        return true;
    }

    public FluidState m_5888_(BlockState p_56969_) {
        return (Boolean)p_56969_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56969_);
    }

    public BlockState m_6843_(BlockState p_56922_, Rotation p_56923_) {
        return (BlockState)p_56922_.m_61124_((Property)FACING, (Comparable)p_56923_.m_55954_((Direction)p_56922_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_56919_, Mirror p_56920_) {
        Direction direction = (Direction)p_56919_.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)p_56919_.m_61143_(SHAPE);
        switch (p_56920_) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return p_56919_.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return p_56919_.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(p_56919_, p_56920_);
    }

    public VoxelShape m_5940_(BlockState p_56956_, BlockGetter p_56957_, BlockPos p_56958_, CollisionContext p_56959_) {
        return (p_56956_.m_61143_(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(p_56956_)]];
    }

    private int getShapeIndex(BlockState p_56983_) {
        return ((StairsShape)p_56983_.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)p_56983_.m_61143_((Property)FACING)).m_122416_();
    }

    public void m_213898_(BlockState p_222523_, ServerLevel p_222524_, BlockPos p_222525_, RandomSource p_222526_) {
        this.base.m_213898_(p_222523_, p_222524_, p_222525_, p_222526_);
    }

    public void m_213897_(BlockState p_222513_, ServerLevel p_222514_, BlockPos p_222515_, RandomSource p_222516_) {
        this.base.m_213897_(p_222513_, p_222514_, p_222515_, p_222516_);
    }

    public void m_6256_(BlockState p_56896_, Level p_56897_, BlockPos p_56898_, Player p_56899_) {
        this.baseState.m_60686_(p_56897_, p_56898_, p_56899_);
    }
}

