/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.IMateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMateriallyTexturedBlock {
    @NotNull
    public Block getBlock();

    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents();

    @NotNull
    default public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedRecipe(){

            public void m_7917_(@NotNull JsonObject json) {
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)IMateriallyTexturedBlock.this.getBlock()));
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }});
    }

    default public boolean isCorrectToolForDrops(BlockState state, ItemStack stack, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return stack.m_41735_(state);
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return stack.m_41735_(block.m_49966_());
            }
        }
        return stack.m_41735_(state);
    }

    default public float getDOExplosionResistance(PropertyDispatch.QuadFunction<BlockState, BlockGetter, BlockPos, Explosion, Float> inputFunction, BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return ((Float)inputFunction.m_176446_((Object)state, (Object)level, (Object)pos, (Object)explosion)).floatValue();
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return block.getExplosionResistance(state, level, pos, explosion);
            }
        }
        return ((Float)inputFunction.m_176446_((Object)state, (Object)level, (Object)pos, (Object)explosion)).floatValue();
    }

    default public float getDODestroyProgress(PropertyDispatch.QuadFunction<BlockState, Player, BlockGetter, BlockPos, Float> inputFunction, BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return ((Float)inputFunction.m_176446_((Object)state, (Object)player, (Object)level, (Object)pos)).floatValue();
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return block.m_5880_(block.m_49966_(), player, level, pos);
            }
        }
        return ((Float)inputFunction.m_176446_((Object)state, (Object)player, (Object)level, (Object)pos)).floatValue();
    }

    default public SoundType getDOSoundType(PropertyDispatch.QuadFunction<BlockState, LevelReader, BlockPos, Entity, SoundType> inputFunction, BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return (SoundType)inputFunction.m_176446_((Object)state, (Object)level, (Object)pos, (Object)entity);
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return block.getSoundType(state, level, pos, entity);
            }
        }
        return (SoundType)inputFunction.m_176446_((Object)state, (Object)level, (Object)pos, (Object)entity);
    }

    default public void fillDOItemCategory(Block inputBlock, @NotNull NonNullList<ItemStack> items, List<ItemStack> fillItemGroupCache) {
        if (!fillItemGroupCache.isEmpty()) {
            items.addAll(fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)inputBlock);
            fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(fillItemGroupCache);
    }

    default public IMateriallyTexturedBlockComponent getMainComponent() {
        return null;
    }

    @NotNull
    default public MaterialTextureData getRandomMaterials() {
        HashMap textureData = Maps.newHashMap();
        for (IMateriallyTexturedBlockComponent component : this.getComponents()) {
            ArrayList<Block> candidates = new ArrayList<Block>(StreamSupport.stream(BuiltInRegistries.f_256975_.m_206058_(component.getValidSkins()).spliterator(), false).map(Holder::m_203334_).toList());
            if (candidates.isEmpty()) continue;
            Block texture = (Block)candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            textureData.put(component.getId(), texture);
        }
        return new MaterialTextureData(textureData);
    }

    default public boolean usesWorldSpecificTinting() {
        return true;
    }
}

