/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature;

import com.blakebr0.cucumber.helper.CropHelper;
import com.blakebr0.pickletweaks.config.ModConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class FeatureRightClickHarvest {
    @SubscribeEvent
    public void onRightClickCrop(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)ModConfigs.ENABLE_RIGHT_CLICK_HARVEST.get()).booleanValue()) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Level level = event.getLevel();
        if (!level.m_5776_()) {
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            Player entity = event.getEntity();
            InteractionHand hand = event.getHand();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)crop);
                if (crop.m_52307_(state) && seed != null) {
                    FeatureRightClickHarvest.handleDrops(state, level, pos, (ItemLike)seed);
                    entity.m_21011_(hand, true);
                    SoundEvent sound = block.getSoundType(state, (LevelReader)level, pos, (Entity)entity).m_56775_();
                    level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_46597_(pos, crop.m_52289_(0));
                }
            }
            if (block instanceof NetherWartBlock && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3) {
                FeatureRightClickHarvest.handleDrops(state, level, pos, (ItemLike)Items.f_42588_);
                entity.m_21011_(hand, true);
                SoundEvent sound = block.getSoundType(state, (LevelReader)level, pos, (Entity)entity).m_56775_();
                level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    private static void handleDrops(BlockState state, Level level, BlockPos pos, ItemLike seed) {
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
        for (ItemStack drop : drops) {
            Item item = drop.m_41720_();
            if (drop.m_41619_() || item != seed) continue;
            drop.m_41774_(1);
            break;
        }
        for (ItemStack drop : drops) {
            if (drop.m_41619_()) continue;
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }
}

