/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Snake;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class SnakeModel
extends GeoModel<Snake> {
    public ResourceLocation getModelResource(Snake snake) {
        return new ResourceLocation("naturalist", "geo/entity/snake.geo.json");
    }

    public ResourceLocation getTextureResource(@NotNull Snake snake) {
        if (snake.m_6095_().equals(NaturalistEntityTypes.CORAL_SNAKE.get())) {
            return new ResourceLocation("naturalist", "textures/entity/snake/coral_snake.png");
        }
        if (snake.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get())) {
            return new ResourceLocation("naturalist", "textures/entity/snake/rattlesnake.png");
        }
        return new ResourceLocation("naturalist", "textures/entity/snake/snake.png");
    }

    public ResourceLocation getAnimationResource(Snake snake) {
        return new ResourceLocation("naturalist", "animations/snake.rp_anim.json");
    }

    public void setCustomAnimations(Snake entity, long instanceId, AnimationState<Snake> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone tail2 = this.getAnimationProcessor().getBone("tail2");
        CoreGeoBone tail4 = this.getAnimationProcessor().getBone("tail4");
        if (!entity.m_5803_()) {
            head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
            head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
        }
        if (!entity.m_21205_().m_41619_()) {
            tail2.setScaleX(1.5f);
            tail2.setScaleY(1.5f);
        }
        tail4.setHidden(!entity.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get()));
    }
}

