/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.block.ChrysalisBlock;
import com.starfish_studios.naturalist.common.entity.core.Catchable;
import com.starfish_studios.naturalist.common.entity.core.ClimbingAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Caterpillar
extends ClimbingAnimal
implements NaturalistGeoEntity,
Catchable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> FROM_HAND;
    protected static final RawAnimation IDLE;
    protected static final RawAnimation CRAWL;

    public Caterpillar(EntityType<? extends NaturalistAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CocoonGoal(this, 1.0, 5, 2));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_146762_(0);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return this.m_6162_() && pStack.m_204117_(ItemTags.f_13149_);
    }

    public float m_6134_() {
        return 1.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Caterpillar> PlayState predicate(AnimationState<E> event) {
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(CRAWL);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public ItemStack getHandItemStack() {
        return new ItemStack((ItemLike)NaturalistRegistry.CATERPILLAR.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_HAND, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromHand", this.fromHand());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFromHand(compound.m_128471_("FromHand"));
    }

    @Override
    public void saveToHandTag(ItemStack stack) {
        Catchable.saveDefaultDataToHandTag((Mob)this, stack);
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128405_("Age", this.m_146764_());
    }

    @Override
    public void loadFromHandTag(CompoundTag tag) {
        Catchable.loadDefaultDataFromHandTag((Mob)this, tag);
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
    }

    @Override
    public boolean fromHand() {
        return (Boolean)this.f_19804_.m_135370_(FROM_HAND);
    }

    @Override
    public void setFromHand(boolean fromHand) {
        this.f_19804_.m_135381_(FROM_HAND, (Object)fromHand);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Catchable.catchAnimal(player, hand, this, true).orElse(super.m_6071_(player, hand));
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromHand();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public ItemStack getCaughtItemStack() {
        return new ItemStack((ItemLike)NaturalistRegistry.CATERPILLAR.get());
    }

    @Override
    public SoundEvent getPickupSound() {
        return null;
    }

    static {
        IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.caterpillar.idle");
        CRAWL = RawAnimation.begin().thenLoop("animation.sf_nba.caterpillar.crawl");
        FROM_HAND = SynchedEntityData.m_135353_(Caterpillar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    private static class CocoonGoal
    extends MoveToBlockGoal {
        private final Caterpillar caterpillar;
        @NotNull
        private Direction facing = Direction.NORTH;
        private BlockPos logPos = BlockPos.f_121853_;

        public CocoonGoal(Caterpillar pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.caterpillar = pMob;
        }

        public boolean m_8036_() {
            return !this.caterpillar.m_6162_() && super.m_8036_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            if (pLevel.m_8055_(pPos).m_60795_()) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!pLevel.m_8055_(pPos.m_121945_(direction)).m_204336_(BlockTags.f_13106_) || !pLevel.m_8055_(pPos.m_121945_(direction).m_7495_()).m_204336_(BlockTags.f_13106_)) continue;
                    this.facing = direction;
                    this.logPos = pPos.m_121945_(direction);
                    return true;
                }
                return false;
            }
            return false;
        }

        public void m_8037_() {
            BlockPos targetPos = this.m_6669_();
            if (!targetPos.m_203195_((Position)this.caterpillar.m_20182_(), this.m_8052_())) {
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.caterpillar.m_21573_().m_26519_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5, this.f_25599_);
                }
            } else {
                --this.f_25601_;
            }
            this.caterpillar.m_21563_().m_24950_((double)this.logPos.m_123341_() + 0.5, (double)(this.logPos.m_123342_() + 1), (double)this.logPos.m_123343_() + 0.5, 10.0f, (float)this.caterpillar.m_8132_());
            Level level = this.caterpillar.m_9236_();
            if (this.m_6465_((LevelReader)level, this.caterpillar.m_20183_())) {
                if (!level.f_46443_) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, NaturalistRegistry.CHRYSALIS_BLOCK.get().m_49966_()), this.caterpillar.m_20185_(), this.caterpillar.m_20186_(), this.caterpillar.m_20189_(), 50, (double)(this.caterpillar.m_20205_() / 4.0f), (double)(this.caterpillar.m_20206_() / 4.0f), (double)(this.caterpillar.m_20205_() / 4.0f), 0.05);
                }
                this.caterpillar.m_146870_();
                level.m_46597_(this.caterpillar.m_20183_(), (BlockState)NaturalistRegistry.CHRYSALIS_BLOCK.get().m_49966_().m_61124_((Property)ChrysalisBlock.f_54117_, (Comparable)this.facing));
                level.m_5594_(null, this.caterpillar.m_20183_(), SoundEvents.f_11991_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            }
        }

        protected void m_25624_() {
            this.caterpillar.m_21573_().m_26519_((double)this.logPos.m_123341_() + 0.5, (double)this.logPos.m_123342_() + 1.0, (double)this.logPos.m_123343_() + 0.5, this.f_25599_);
        }

        protected BlockPos m_6669_() {
            return this.logPos.m_7494_();
        }
    }
}

