/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders.rgb;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RgbSlider
extends BasicSlider {
    public static final int SLIDER_PADDING = 2;
    protected final Seasons season;
    private final boolean enableColor = SeasonHudClient.getEnableSeasonNameColor();
    protected ColorEditBox seasonBox;
    protected int red;
    protected int green;
    protected int blue;
    protected int rgb;

    public RgbSlider(int x, int y, int initial, ColorEditBox seasonBox, ChatFormatting textColor) {
        super(x, y, seasonBox.m_5711_() + 2, seasonBox.m_93694_() - 6, true, initial, 0.0, 255.0, seasonBox.getSeason().getDefaultColor(), textColor);
        this.seasonBox = seasonBox;
        this.season = seasonBox.getSeason();
        this.rgb = Integer.parseInt(seasonBox.m_94155_());
        this.red = Rgb.red(this.rgb);
        this.green = Rgb.green(this.rgb);
        this.blue = Rgb.blue(this.rgb);
        this.m_5695_();
    }

    @Override
    public void m_5716_(double x, double y) {
        if (this.enableColor) {
            super.m_5716_(x, y);
        }
    }

    @Override
    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.enableColor) {
            super.m_7212_(mouseX, mouseY, dragX, dragY);
        }
    }

    @Override
    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.enableColor) {
            this.f_93623_ = false;
            this.f_93622_ = false;
        }
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
    }

    public void setValue(int newValue) {
        double oldValue = this.f_93577_;
        this.f_93577_ = this.snapToNearest(((double)newValue - this.minValue) / (this.maxValue - this.minValue));
        if (!Mth.m_14082_((double)oldValue, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    @Override
    protected void m_5695_() {
        MutableComponent colorString = Common.literalText(this.getValueString());
        this.m_93666_((Component)colorString.m_6881_().m_130940_(this.textColor));
        if (!this.enableColor) {
            this.m_93666_((Component)colorString.m_6881_().m_130940_(ChatFormatting.GRAY));
        }
    }
}

