/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.client.gui.components.buttons.DefaultColorButton;
import club.iananderson.seasonhud.client.gui.components.sliders.rgb.BlueSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.rgb.GreenSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.rgb.RedSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorScreen
extends SeasonHudScreen {
    private static final Component SCREEN_TITLE = Common.translatedText("menu.seasonhud.color.title");
    private final List<ColorEditBox> seasonBoxes = new ArrayList<ColorEditBox>();
    private int posX;
    private int posY;
    private boolean seasonColor;

    public ColorScreen(Screen parentScreen) {
        super(parentScreen, SCREEN_TITLE);
        this.buttonWidth = 170;
        this.loadConfig();
    }

    public static ColorScreen getInstance(Screen parentScreen) {
        return new ColorScreen(parentScreen);
    }

    private static EnumSet<Seasons> seasonListSet() {
        Object set = Seasons.SEASONS_ENUM_LIST.clone();
        ((AbstractCollection)set).remove((Object)Seasons.NULL);
        if (!SeasonHudClient.getShowTropicalSeason() || Common.fabricSeasonsLoaded()) {
            ((AbstractCollection)set).remove((Object)Seasons.DRY);
            ((AbstractCollection)set).remove((Object)Seasons.WET);
        }
        return set;
    }

    public void loadConfig() {
        this.seasonColor = SeasonHudClient.getEnableSeasonNameColor();
    }

    @Override
    public void onDone() {
        this.seasonBoxes.forEach(editBox -> {
            if (Integer.parseInt(editBox.m_94155_()) != editBox.getColor()) {
                editBox.save();
            }
        });
        super.onDone();
    }

    @Override
    public void m_7379_() {
        SeasonHudClient.setEnableSeasonNameColor(this.seasonColor);
        super.m_7379_();
    }

    public int getBoxWidth() {
        int widgetCount = ColorScreen.seasonListSet().size();
        int widgetTotalSize = 86 * widgetCount;
        int boxWidth = this.f_96543_ < widgetTotalSize ? 60 : 80;
        return boxWidth;
    }

    private List<AbstractWidget> seasonWidget(int x, int y, Seasons season) {
        ColorEditBox colorBox = new ColorEditBox(this.f_96547_, x, y, this.getBoxWidth(), this.buttonHeight, season);
        y += colorBox.m_93694_() + 6;
        int initialR = Rgb.red(colorBox.getColor());
        RedSlider redSlider = new RedSlider(--x, y += this.buttonHeight + 2, initialR, colorBox);
        int initialG = Rgb.green(colorBox.getColor());
        GreenSlider greenSlider = new GreenSlider(x, y += redSlider.m_93694_() + 2, initialG, colorBox);
        int initialB = Rgb.blue(colorBox.getColor());
        BlueSlider blueSlider = new BlueSlider(x, y += greenSlider.m_93694_() + 2, initialB, colorBox);
        DefaultColorButton defaultButton = DefaultColorButton.builder(colorBox, press -> {
            int defaultColorInt = season.getDefaultColor();
            if (colorBox.getNewColor() != defaultColorInt) {
                int r = Rgb.red(defaultColorInt);
                int g = Rgb.green(defaultColorInt);
                int b = Rgb.blue(defaultColorInt);
                redSlider.setValue(r);
                greenSlider.setValue(g);
                blueSlider.setValue(b);
                colorBox.m_94144_(String.valueOf(defaultColorInt));
                Rgb.setRgb(season, defaultColorInt);
            }
        }).withPos(x, y -= greenSlider.m_93694_() + redSlider.m_93694_() + 2 + this.buttonHeight + 2).build();
        this.seasonBoxes.add(colorBox);
        return new ArrayList<AbstractWidget>(Arrays.asList(new AbstractWidget[]{colorBox, defaultButton, redSlider, greenSlider, blueSlider}));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int widgetWidth = this.getBoxWidth() + 6;
        int totalWidgetWidth = ColorScreen.seasonListSet().size() * widgetWidth - 6;
        this.posX = this.f_96543_ / 2 - totalWidgetWidth / 2;
        this.posY = 50 + this.buttonHeight + 6 + this.buttonHeight;
        ColorScreen.seasonListSet().forEach(season -> {
            this.widgets.addAll(this.seasonWidget(this.posX, this.posY, (Seasons)((Object)season)));
            this.posX += widgetWidth;
        });
        CycleButton seasonColorButton = CycleButton.m_168916_((boolean)SeasonHudClient.getEnableSeasonNameColor()).m_232498_(t -> Common.newTooltip("menu.seasonhud.color.enableSeasonNameColor.tooltip")).m_168936_(this.leftButtonX, 50, this.buttonWidth, this.buttonHeight, (Component)Common.translatedText("menu.seasonhud.color.enableSeasonNameColor.button"), (b, val) -> {
            SeasonHudClient.setEnableSeasonNameColor(val);
            this.m_232761_();
        });
        this.widgets.add(seasonColorButton);
        this.widgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void m_86600_() {
        this.seasonBoxes.forEach(EditBox::m_94120_);
        super.m_86600_();
    }
}

