/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class MapAtlasesCommon {
    private MapAtlasesCommon() {
    }

    private static void drawSeasonWithLighterShadow(GuiGraphics graphics, Font font, MutableComponent text, MutableComponent shadowText) {
        graphics.m_280614_(font, (Component)shadowText, 1, 1, 0x595959, false);
        graphics.m_280614_(font, (Component)text, 0, 0, 0xFFFFFF, false);
    }

    private static void drawScaledComponent(GuiGraphics graphics, Font font, int x, int y, MutableComponent text, MutableComponent shadowText, float textScaling, int maxWidth, int targetWidth) {
        PoseStack pose = graphics.m_280168_();
        float textWidth = font.m_92852_((FormattedText)text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        pose.m_85836_();
        pose.m_252880_(centerX, (float)(y + 4), 5.0f);
        pose.m_85841_(scale *= textScaling, scale, 1.0f);
        pose.m_252880_(-textWidth / 2.0f, -4.0f, 0.0f);
        MapAtlasesCommon.drawSeasonWithLighterShadow(graphics, font, text, shadowText);
        pose.m_85849_();
    }

    public static void drawMapComponentSeason(GuiGraphics graphics, Font font, int x, int y, int targetWidth, float textScaling, float globalScale) {
        MutableComponent seasonCombined = CurrentSeason.getInstance(Minecraft.m_91087_()).getHudText();
        MutableComponent seasonShadowText = CurrentSeason.getInstance(Minecraft.m_91087_()).getHudTextNoFormat();
        MutableComponent fertility = CurrentFertility.getInstance(Minecraft.m_91087_()).getMinimapText();
        MutableComponent fertilityShadowText = CurrentFertility.getInstance(Minecraft.m_91087_()).getHudTextNoFormat();
        MapAtlasesCommon.drawScaledComponent(graphics, font, x, y, seasonCombined, seasonShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
            Objects.requireNonNull(font);
            MapAtlasesCommon.drawScaledComponent(graphics, font, x, y + 9, fertility, fertilityShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        }
    }
}

