/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SeasonHudOverlayCommon {
    private SeasonHudOverlayCommon() {
    }

    public static void render(GuiGraphics graphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (Common.drawDefaultHud() && Common.vanillaShouldDrawHud() && Calendar.validNeedCalendar() && !Common.hideHudInCurrentDimension()) {
            int x;
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int offsetX = SeasonHudClient.getHudX();
            int offsetY = SeasonHudClient.getHudY();
            double scale = SeasonHudClient.getHudScale();
            int defaultOffsetX = 2;
            int defaultOffsetY = 2;
            MutableComponent seasonCombined = CurrentSeason.getInstance(mc).getHudText();
            int stringWidth = (int)((double)mc.f_91062_.m_92852_((FormattedText)seasonCombined) * scale);
            Objects.requireNonNull(mc.f_91062_);
            int stringHeight = (int)(9.0 * scale);
            int y = switch (SeasonHudClient.getHudLocation()) {
                case Location.TOP_LEFT -> {
                    x = defaultOffsetX;
                    yield defaultOffsetY;
                }
                case Location.TOP_CENTER -> {
                    x = (int)(((double)screenWidth / 2.0 - (double)stringWidth / 2.0) / scale);
                    yield defaultOffsetY;
                }
                case Location.TOP_RIGHT -> {
                    x = (int)((double)(screenWidth - stringWidth - defaultOffsetX) / scale);
                    yield defaultOffsetY;
                }
                case Location.BOTTOM_LEFT -> {
                    x = defaultOffsetX;
                    yield (int)((double)(screenHeight - stringHeight - defaultOffsetY) / scale);
                }
                case Location.BOTTOM_RIGHT -> {
                    x = (int)((double)(screenWidth - stringWidth - defaultOffsetX) / scale);
                    yield (int)((double)(screenHeight - stringHeight - defaultOffsetY) / scale);
                }
                case Location.CUSTOM -> {
                    x = offsetX;
                    yield offsetY;
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)SeasonHudClient.getHudLocation()));
            };
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_((float)scale, (float)scale, 1.0f);
            graphics.m_280430_(mc.f_91062_, (Component)seasonCombined, x, y, 0xFFFFFF);
            if (SeasonHudClient.getShowFertility()) {
                MutableComponent fertility = CurrentFertility.getInstance(mc).getHudText();
                graphics.m_280430_(mc.f_91062_, (Component)fertility, x, y += stringHeight, 0xFFFFFF);
            }
            graphics.m_280168_().m_85849_();
        }
    }
}

