/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CommonSeasonHelper;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import java.time.LocalDateTime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class CurrentSeason {
    private final String currentSeason;
    private final String currentSubSeason;
    private final String seasonFileName;
    private final long seasonDate;
    private final int seasonDuration;
    private Style seasonFormat;

    public CurrentSeason(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        this.seasonFormat = Style.f_131099_;
        this.currentSeason = CommonSeasonHelper.commonSeasons.getCurrentSeason((Player)player);
        this.currentSubSeason = CommonSeasonHelper.commonSeasons.getCurrentSubSeason((Player)player);
        this.seasonFileName = CommonSeasonHelper.commonSeasons.getSeasonFileName((Player)player);
        this.seasonDate = CommonSeasonHelper.commonSeasons.getDate((Player)player);
        this.seasonDuration = CommonSeasonHelper.commonSeasons.seasonDuration((Player)player);
    }

    public static CurrentSeason getInstance(Minecraft mc) {
        return new CurrentSeason(mc);
    }

    public String getSubSeasonLowerCase() {
        String lowerSubSeason = this.currentSubSeason.toLowerCase();
        if (Common.fabricSeasonsLoaded()) {
            return this.currentSeason.toLowerCase();
        }
        return this.currentSeason.toLowerCase() + "." + lowerSubSeason.substring(0, lowerSubSeason.indexOf("_"));
    }

    public String getSeasonLowerCase() {
        return this.currentSeason.toLowerCase();
    }

    public Component getKey(boolean showSubSeason) {
        String season;
        String string = season = showSubSeason ? this.getSubSeasonLowerCase() : this.getSeasonLowerCase();
        if (!Calendar.validDetailedMode() || Common.fabricSeasonsLoaded()) {
            season = this.getSeasonLowerCase();
        }
        if (Common.eclipticSeasonsLoaded() && Calendar.validDetailedMode() && SeasonHudClient.getShowSubSeason()) {
            season = this.currentSubSeason;
            if (this.currentSubSeason.equals("MID_NULL")) {
                return Common.translatedText("desc.seasonhud.season." + this.getSubSeasonLowerCase());
            }
            return Common.translatedText("info.eclipticseasons.environment.solar_term." + season);
        }
        return Common.translatedText("desc.seasonhud.season." + season);
    }

    public String getIcon() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getIconChar();
        }
        return "Icon Error";
    }

    public Component getText(ShowDay showDay, boolean showSubSeason) {
        MutableComponent text;
        Component seasonKey = this.getKey(showSubSeason);
        switch (showDay) {
            case NONE: {
                text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                break;
            }
            case SHOW_DAY: {
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
                break;
            }
            case SHOW_WITH_TOTAL_DAYS: {
                text = Common.translatedText(ShowDay.SHOW_WITH_TOTAL_DAYS.getKey(), seasonKey, this.seasonDate, this.seasonDuration);
                break;
            }
            case SHOW_WITH_MONTH: {
                if (CommonSeasonHelper.commonSeasons.isSeasonTiedWithSystemTime()) {
                    int systemMonth = LocalDateTime.now().getMonth().getValue();
                    Object systemMonthString = String.valueOf(systemMonth);
                    if (systemMonth < 10) {
                        systemMonthString = "0" + (String)systemMonthString;
                    }
                    MutableComponent currentMonth = Common.translatedText("desc.seasonhud.month." + (String)systemMonthString);
                    text = Common.translatedText(ShowDay.SHOW_WITH_MONTH.getKey(), seasonKey, currentMonth, this.seasonDate);
                    if (Calendar.validDetailedMode()) break;
                    text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                    break;
                }
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)showDay));
            }
        }
        return text;
    }

    public int getTextColor() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getSeasonColor();
        }
        return 0xFFFFFF;
    }

    public MutableComponent getHudTextNoFormat() {
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getIcon()).m_130948_(Common.SEASON_ICON_STYLE);
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        MutableComponent seasonText = this.getText(showDay, showSubSeason).m_6881_();
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon, seasonText);
    }

    public MutableComponent getHudText() {
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        MutableComponent seasonText = this.getText(showDay, showSubSeason).m_6881_();
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.f_131099_.m_178520_(this.getTextColor());
        }
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getIcon()).m_130948_(Common.SEASON_ICON_STYLE);
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon, seasonText.m_130948_(this.seasonFormat));
    }

    public MutableComponent getMenuText(Seasons season, int newRgb, boolean seasonShort) {
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.f_131099_.m_178520_(newRgb);
        }
        MutableComponent seasonText = Common.translatedText(ShowDay.NONE.getKey(), season.getSeasonName());
        if (season == Seasons.DRY && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.dry.editbox");
        }
        if (season == Seasons.WET && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.wet.editbox");
        }
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", season.getIconChar()).m_130948_(Common.SEASON_ICON_STYLE);
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon, seasonText.m_130948_(this.seasonFormat));
    }

    public MutableComponent getConfigText(ShowDay showDay, boolean showSubSeason, boolean seasonColor) {
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getIcon());
        MutableComponent seasonText = this.getText(showDay, showSubSeason).m_6881_();
        if (seasonColor) {
            this.seasonFormat = Style.f_131099_.m_178520_(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.m_130948_(Common.SEASON_ICON_STYLE), seasonText.m_130948_(this.seasonFormat));
    }
}

