/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.KeyBindings;
import com.direwolf20.buildinggadgets2.client.screen.widgets.GuiIconActionable;
import com.direwolf20.buildinggadgets2.client.screen.widgets.IncrementalSliderWidget;
import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketAnchor;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketDestructionRanges;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketRenderChange;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketToggleSetting;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketUndo;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class DestructionGUI
extends Screen {
    private final Set<IncrementalSliderWidget> sliders = new HashSet<IncrementalSliderWidget>();
    private IncrementalSliderWidget left;
    private IncrementalSliderWidget right;
    private IncrementalSliderWidget up;
    private IncrementalSliderWidget down;
    private IncrementalSliderWidget depth;
    private int originalLeft;
    private int originalRight;
    private int originalUp;
    private int originalDown;
    private int originalDepth;
    private Button confirm;
    private String sizeString = "";
    private boolean isValidSize = true;
    private boolean keyDown = false;
    private final ItemStack destructionGadget;
    private Button renderTypeButton;
    private GadgetNBT.RenderTypes renderType;

    public DestructionGUI(ItemStack tool, boolean keyDown) {
        super((Component)Component.m_237119_());
        this.destructionGadget = tool;
        this.keyDown = keyDown;
        this.renderType = GadgetNBT.getRenderType(tool);
    }

    public void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"buildinggadgets2.screen.revert"), b -> {
            this.depth.m_93611_(this.originalDepth);
            this.right.m_93611_(this.originalRight);
            this.left.m_93611_(this.originalLeft);
            this.up.m_93611_(this.originalUp);
            this.down.m_93611_(this.originalDown);
            this.sendPacket();
        }).m_252794_(x - 30 + 32, y + 65).m_253046_(60, 20).m_253136_());
        GuiIconActionable undo_button = new GuiIconActionable(x - 55, y - 75, "undo", (Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.undo"), false, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketUndo());
            }
            return false;
        });
        this.m_142416_((GuiEventListener)undo_button);
        GuiIconActionable anchorButton = new GuiIconActionable(x - 25, y - 75, "anchor", (Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.anchor"), true, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketAnchor());
            }
            return !GadgetNBT.getAnchorPos(this.destructionGadget).equals((Object)GadgetNBT.nullPos);
        });
        this.m_142416_((GuiEventListener)anchorButton);
        GuiIconActionable affectTiles = new GuiIconActionable(x + 5, y - 75, "affecttiles", (Component)Component.m_237115_((String)"buildinggadgets2.screen.affecttiles"), true, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleSetting("affecttiles"));
            }
            return GadgetNBT.getSetting(this.destructionGadget, "affecttiles");
        });
        this.m_142416_((GuiEventListener)affectTiles);
        GuiIconActionable rayTrace = new GuiIconActionable(x + 35, y - 75, "raytrace_fluid", (Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.raytracefluids"), true, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleSetting("raytracefluid"));
            }
            return GadgetNBT.getSetting(this.destructionGadget, "raytracefluid");
        });
        this.m_142416_((GuiEventListener)rayTrace);
        this.renderTypeButton = new GuiIconActionable(x + 65, y - 75, "raytrace_fluid", (Component)Component.m_237115_((String)this.renderType.getLang()), false, send -> {
            if (send.booleanValue()) {
                this.renderType = this.renderType.next();
                this.renderTypeButton.m_93666_((Component)Component.m_237115_((String)this.renderType.getLang()));
                PacketHandler.sendToServer(new PacketRenderChange(this.renderType.getPosition()));
            }
            return false;
        });
        this.m_142416_((GuiEventListener)this.renderTypeButton);
        this.sliders.clear();
        this.depth = this.createSlider(x - 35, y - 7, Component.m_237115_((String)"buildinggadgets2.screen.depth"), GadgetNBT.getToolValue(this.destructionGadget, "depth"));
        this.sliders.add(this.depth);
        this.right = this.createSlider(x + 75, y - 7, Component.m_237115_((String)"buildinggadgets2.screen.right"), GadgetNBT.getToolValue(this.destructionGadget, "right"));
        this.sliders.add(this.right);
        this.left = this.createSlider(x - 140 - 5, y - 7, Component.m_237115_((String)"buildinggadgets2.screen.left"), GadgetNBT.getToolValue(this.destructionGadget, "left"));
        this.sliders.add(this.left);
        this.up = this.createSlider(x - 35, y - 35, Component.m_237115_((String)"buildinggadgets2.screen.up"), GadgetNBT.getToolValue(this.destructionGadget, "up"));
        this.sliders.add(this.up);
        this.down = this.createSlider(x - 35, y + 20, Component.m_237115_((String)"buildinggadgets2.screen.down"), GadgetNBT.getToolValue(this.destructionGadget, "down"));
        this.sliders.add(this.down);
        this.originalDepth = this.depth.getValueInt();
        this.originalLeft = this.left.getValueInt();
        this.originalRight = this.right.getValueInt();
        this.originalUp = this.up.getValueInt();
        this.originalDown = this.down.getValueInt();
        this.updateSizeString();
        this.updateIsValid();
        this.sliders.forEach(gui -> gui.getComponents().forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }));
    }

    public IncrementalSliderWidget createSlider(int x, int y, MutableComponent prefix, int value) {
        return new IncrementalSliderWidget(x, y, 70, 14, 0.0, 16.0, (Component)prefix.m_130946_(": "), value, this::onSliderUpdate);
    }

    public void onSliderUpdate(IncrementalSliderWidget widget) {
        this.updateSizeString();
        this.updateIsValid();
        this.sendPacket();
    }

    private boolean isWithinBounds() {
        int x = this.left.getValueInt() + this.right.getValueInt();
        int y = this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        int dim = 16;
        return x <= dim && y <= dim && z <= dim;
    }

    private String getSizeString() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        return String.format("%d x %d x %d", x, y, z);
    }

    private void updateIsValid() {
        this.isValidSize = this.isWithinBounds();
    }

    private void updateSizeString() {
        this.sizeString = this.getSizeString();
    }

    private void sendPacket() {
        if (this.isWithinBounds()) {
            PacketHandler.sendToServer(new PacketDestructionRanges(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()));
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280137_(this.f_96547_, this.sizeString, this.f_96543_ / 2, this.f_96544_ / 2 + 40, this.isValidSize ? 65280 : 0xFF2000);
        if (!this.isValidSize) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"buildinggadgets2.screen.destructiontoolarge"), this.f_96543_ / 2, this.f_96544_ / 2 + 50, 0xFF2000);
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public void m_86600_() {
        if (this.keyDown && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)KeyBindings.menuSettings.getKey().m_84873_())) {
            this.m_7379_();
        }
        super.m_86600_();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.keyDown) {
            return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

