/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketSendCopyData;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketRequestCopyData {
    private UUID gadgetUUID;
    private UUID copyUUID;

    public PacketRequestCopyData(UUID gadgetUUID, UUID copyUUID) {
        this.gadgetUUID = gadgetUUID;
        this.copyUUID = copyUUID;
    }

    public static PacketRequestCopyData decode(FriendlyByteBuf buf) {
        return new PacketRequestCopyData(buf.m_130259_(), buf.m_130259_());
    }

    public static void encode(PacketRequestCopyData message, FriendlyByteBuf buf) {
        buf.m_130077_(message.gadgetUUID);
        buf.m_130077_(message.copyUUID);
    }

    public static void handle(PacketRequestCopyData message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            if (ServerTickHandler.gadgetWorking(message.gadgetUUID)) {
                return;
            }
            BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(sender.m_9236_().m_7654_()).m_129783_());
            CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(message.gadgetUUID, false);
            PacketHandler.sendTo(new PacketSendCopyData(message.gadgetUUID, message.copyUUID, tag), sender);
        });
        context.get().setPacketHandled(true);
    }
}

