/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;

public class DogRandomNameRegistry
extends SimplePreparableReloadListener<Prep> {
    private static ResourceLocation NAME_RES = Util.getResource("dogname/name.json");
    private static DogRandomNameRegistry INSTANCE = new DogRandomNameRegistry();
    private static final Gson GSON = new Gson();
    private List<String> nameList = List.of();

    public static DogRandomNameRegistry getInstance() {
        return INSTANCE;
    }

    public String getRandomName(Dog dog) {
        if (this.nameList.isEmpty()) {
            return "";
        }
        int r = dog.m_217043_().m_188503_(this.nameList.size());
        return this.nameList.get(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Prep prepare(ResourceManager resMan, ProfilerFiller p_10797_) {
        InputStream istream = null;
        Prep prep = new Prep(new ArrayList<String>());
        try {
            Resource res = (Resource)resMan.m_213713_(NAME_RES).get();
            istream = res.m_215507_();
            JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement e : jsonArray) {
                String name = e.getAsString();
                prep.names.add(name);
            }
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(istream);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(istream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)istream);
        return prep;
    }

    protected void apply(Prep prep, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        this.nameList = List.copyOf(Set.copyOf(prep.names));
    }

    public record Prep(List<String> names) {
    }
}

