/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.data;

import doggytalents.DoggyBlocks;
import doggytalents.common.block.crops.DogCropBlock;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DTBlockstateProvider
extends BlockStateProvider {
    private static final String RENDERTYPE_CUTOUT = "cutout";
    private static BiFunction<String, Direction, BiConsumer<Direction, ModelBuilder.FaceBuilder>> cullFaceFactory = (texture, input) -> (d, b) -> b.texture(texture).cullface((Direction)(d == input ? d : null));

    public DTBlockstateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "doggytalents", exFileHelper);
    }

    public ExistingFileHelper getExistingHelper() {
        return this.models().existingFileHelper;
    }

    public String m_6055_() {
        return "DoggyTalents Blockstates/Block Models";
    }

    protected void registerStatesAndModels() {
        this.dogBath((Supplier<? extends Block>)DoggyBlocks.DOG_BATH);
        this.dogBed((Supplier<? extends Block>)DoggyBlocks.DOG_BED);
        this.createFromShape((Supplier<? extends Block>)DoggyBlocks.FOOD_BOWL, new AABB(1.0, 0.0, 1.0, 15.0, 8.0, 15.0));
        this.doggyCrops((Supplier<? extends DogCropBlock>)DoggyBlocks.RICE_CROP);
        this.doggyCrops((Supplier<? extends DogCropBlock>)DoggyBlocks.SOY_CROP);
        this.particleOnly((Block)DoggyBlocks.RICE_MILL.get(), Blocks.f_50705_);
    }

    protected void createFromShape(Supplier<? extends Block> blockIn, AABB bb) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(blockIn.get()))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", this.extend(this.blockTexture(blockIn.get()), "_bottom"))).texture("bottom", this.extend(this.blockTexture(blockIn.get()), "_bottom"))).texture("top", this.extend(this.blockTexture(blockIn.get()), "_top"))).texture("side", this.extend(this.blockTexture(blockIn.get()), "_side"));
        model.element().from((float)bb.f_82288_, (float)bb.f_82289_, (float)bb.f_82290_).to((float)bb.f_82291_, (float)bb.f_82292_, (float)bb.f_82293_).allFaces((d, f) -> f.cullface((Direction)(d == Direction.DOWN ? d : null)).texture(d.m_122434_().m_122479_() ? "#side" : (d == Direction.DOWN ? "#bottom" : "#top")));
        this.simpleBlock(blockIn.get(), (ModelFile)model);
    }

    protected void dogBed(Supplier<? extends Block> blockIn) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(blockIn.get()))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", this.blockTexture(Blocks.f_50705_))).texture("bedding", this.blockTexture(Blocks.f_50041_))).texture("casing", this.blockTexture(Blocks.f_50705_))).ao(false);
        model.element().from(1.6f, 3.2f, 1.6f).to(14.4f, 6.4f, 14.4f).face(Direction.UP).texture("#bedding").end().face(Direction.NORTH).texture("#bedding");
        model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 3.2f, 16.0f).allFaces(cullFaceFactory.apply("#casing", Direction.DOWN));
        model.element().from(11.2f, 3.2f, 0.0f).to(16.0f, 9.6f, 1.6f).allFaces(cullFaceFactory.apply("#casing", Direction.NORTH));
        model.element().from(0.0f, 3.2f, 0.0f).to(4.8f, 9.6f, 1.6f).allFaces(cullFaceFactory.apply("#casing", Direction.NORTH));
        model.element().from(14.4f, 3.2f, 0.0f).to(16.0f, 9.6f, 16.0f).allFaces(cullFaceFactory.apply("#casing", Direction.EAST));
        model.element().from(0.0f, 3.2f, 14.4f).to(16.0f, 9.6f, 16.0f).allFaces(cullFaceFactory.apply("#casing", Direction.SOUTH));
        model.element().from(0.0f, 3.2f, 0.0f).to(1.6f, 9.6f, 16.0f).allFaces(cullFaceFactory.apply("#casing", Direction.WEST));
        this.simpleBlock(blockIn.get(), (ModelFile)model);
    }

    protected void dogBath(Supplier<? extends Block> blockIn) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(blockIn.get()))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", this.blockTexture(Blocks.f_50075_))).texture("water", this.extend(this.blockTexture(Blocks.f_49990_), "_still"))).texture("side", this.blockTexture(Blocks.f_50075_))).texture("bottom", this.blockTexture(Blocks.f_50075_))).ao(false);
        model.element().from(1.0f, 0.0f, 1.0f).to(15.0f, 6.0f, 15.0f).face(Direction.UP).texture("#water").tintindex(0);
        model.element().from(1.0f, 0.0f, 1.0f).to(15.0f, 6.0f, 15.0f).face(Direction.DOWN).texture("#bottom");
        model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 1.0f).allFaces(cullFaceFactory.apply("#side", Direction.NORTH));
        model.element().from(15.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f).allFaces(cullFaceFactory.apply("#side", Direction.EAST));
        model.element().from(0.0f, 0.0f, 15.0f).to(16.0f, 8.0f, 16.0f).allFaces(cullFaceFactory.apply("#side", Direction.SOUTH));
        model.element().from(0.0f, 0.0f, 0.0f).to(1.0f, 8.0f, 16.0f).allFaces(cullFaceFactory.apply("#side", Direction.WEST));
        this.simpleBlock(blockIn.get(), (ModelFile)model);
    }

    private void doggyCrops(Supplier<? extends DogCropBlock> cropBlockSup) {
        DogCropBlock cropBlock = cropBlockSup.get();
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder((Block)cropBlock);
        IntegerProperty ageProp = cropBlock.m_7959_();
        List possibleAges = ageProp.m_61702_().collect(Collectors.toList());
        for (Property.Value age : possibleAges) {
            VariantBlockStateBuilder.PartialBlockstate partialState = variantBuilder.partialState().with((Property)ageProp, (Comparable)((Integer)age.f_61713_()));
            String modelName = this.cropState(cropBlock, (Integer)age.f_61713_());
            ResourceLocation modelTexture = this.cropTexture(cropBlock, (Integer)age.f_61713_());
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().crop(modelName, modelTexture)).renderType(RENDERTYPE_CUTOUT);
            variantBuilder.addModels(partialState, new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
    }

    private String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private String cropState(DogCropBlock block, int age) {
        return this.name((Block)block) + "/stage_" + age;
    }

    private ResourceLocation cropTexture(DogCropBlock block, int age) {
        return this.extend(this.blockTexture((Block)block), "/stage_" + age);
    }

    public ResourceLocation blockTexture(Block block) {
        ResourceLocation base = ForgeRegistries.BLOCKS.getKey((Object)block);
        return this.prextend(base, "block/");
    }

    public ModelFile cross(Supplier<? extends Block> block) {
        return this.models().cross(this.name(block.get()), this.blockTexture(block.get()));
    }

    private void particleOnly(Block block, Block textureBlock) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.blockTexture(textureBlock));
        this.simpleBlock(block, (ModelFile)model);
    }

    protected void makeSimple(Supplier<? extends Block> blockIn) {
        this.simpleBlock(blockIn.get());
    }

    private ResourceLocation prextend(ResourceLocation rl, String prefix) {
        return new ResourceLocation(rl.m_135827_(), prefix + rl.m_135815_());
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }
}

