/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.ElytraCapeModel;
import doggytalents.common.entity.Dog;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class FieryReflectorModel
extends ElytraCapeModel {
    public ModelPart reflector;
    public ModelPart divineCape;
    private boolean incapacitated;

    public FieryReflectorModel(ModelPart root) {
        super(root);
    }

    @Override
    protected void populatePart(ModelPart box) {
        super.populatePart(box);
        this.reflector = this.elytra.m_171324_("disc");
        this.divineCape = this.elytra.m_171324_("divine_cape");
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(dogIn, limbSwing, limbSwingAmount, partialTickTime);
        this.incapacitated = !dogIn.isDoingFine();
        this.lWing.f_104207_ = !this.incapacitated;
        this.rWing.f_104207_ = !this.incapacitated;
        this.divineCape.f_104207_ = !this.incapacitated;
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.reflector.f_104204_ = 6.0f * ageInTicks % 360.0f * ((float)Math.PI / 180);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition upper_body = partdefinition.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.m_171599_("elytra_rot", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.m_171599_("elytra", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition divine_cape = elytra.m_171599_("divine_cape", CubeListBuilder.m_171558_().m_171514_(30, 42).m_171480_().m_171488_(-5.8914f, 3.8079f, 2.3224f, 15.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-1.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition disc = elytra.m_171599_("disc", CubeListBuilder.m_171558_().m_171514_(24, 29).m_171488_(-5.0f, -0.35f, -5.15f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 29).m_171488_(-5.0f, -0.35f, -5.15f, 10.0f, 1.0f, 10.0f, new CubeDeformation(-0.099f)).m_171514_(28, 33).m_171488_(-3.0f, -0.55f, -3.15f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.1f)).m_171514_(32, 37).m_171488_(-1.0f, -1.6f, -1.15f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)-5.9f, (float)7.4f));
        PartDefinition cube_r1 = disc.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(28, 33).m_171488_(-3.0f, -0.5f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)0.0f, (float)-0.05f, (float)-0.15f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition right_wing = elytra.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_r1 = right_wing.m_171599_("right_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-6.6851f, 3.7889f, 2.3232f, 12.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)-0.1309f, (float)0.0f));
        PartDefinition left_wing = elytra.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_r1 = left_wing.m_171599_("left_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(-4.8914f, 3.8079f, 2.3224f, 12.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void m_7695_(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, float p_103017_, float p_103018_, float p_103019_, float p_103020_) {
        super.m_7695_(stack, p_103014_, this.incapacitated ? p_103015_ : 0xF000F0, p_103016_, p_103017_, p_103018_, p_103019_, p_103020_);
    }
}

