/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.skin;

import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.entity.Dog;

public class DogSkinHolder {
    private static final DogSkinHolder NONE = new DogSkinHolder(null);
    private DogSkin skin = null;

    private DogSkinHolder(DogSkin skin) {
        this.skin = skin;
    }

    public DogSkin getOrElse(DogSkin skin) {
        return this.skin == null ? skin : this.skin;
    }

    public void invalidate() {
        this.skin = null;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public static DogSkinHolder getNone() {
        return NONE;
    }

    public static DogSkinHolder update(Dog dog, DogSkinHolder current) {
        if (current.isNone()) {
            return current;
        }
        if (current.skin != null) {
            return current;
        }
        String hash = dog.getSkinData().getHash();
        if (hash != null) {
            return DogSkinHolder.resolve(hash);
        }
        return DogSkinHolder.getNone();
    }

    private static DogSkinHolder resolve(String hash) {
        return DogTextureManager.INSTANCE.getDogSkin(hash);
    }

    public static DogSkinHolder resolved(DogSkin skin) {
        if (skin == null) {
            return DogSkinHolder.getNone();
        }
        return new DogSkinHolder(skin);
    }

    public static DogSkinHolder pendingResolve() {
        return new DogSkinHolder(null);
    }
}

