/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.util.DogFoodUtil;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MeatFoodHandler
implements IDogFoodHandler {
    @Override
    public boolean isFood(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42583_) {
            return false;
        }
        return DogFoodUtil.isMeat(stack);
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, @Nullable Entity entityIn) {
        return this.isFood(stackIn) && !dog.isDefeated();
    }

    @Override
    public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        if (dog.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (dog.canStillEat()) {
            if (!dog.m_9236_().f_46443_) {
                Item item = stack.m_41720_();
                FoodProperties props = item.m_41473_();
                if (props == null) {
                    return InteractionResult.FAIL;
                }
                int heal = props.m_38744_() * 5;
                dog.addHunger(heal);
                dog.consumeItemFromStack(entityIn, stack);
                if (dog.m_9236_() instanceof ServerLevel) {
                    ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)item));
                }
                dog.m_5496_(SoundEvents.f_11912_, dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

