/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DogNodeEvaluator
extends WalkNodeEvaluator {
    private final Supplier<Dog> dogGetter;

    public DogNodeEvaluator(Supplier<Dog> dogGetter) {
        this.dogGetter = dogGetter;
    }

    protected double m_142213_(BlockPos pos) {
        Dog dog = this.dogGetter.get();
        if (dog.m_5825_() && dog.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
            return pos.m_123342_();
        }
        return super.m_142213_(pos);
    }

    @Nullable
    protected Node m_164725_(int x, int y, int z, int floorLevel, double maxUpStep, Direction dir, BlockPathTypes centerType) {
        if (centerType == BlockPathTypes.DOOR_WOOD_CLOSED && this.dogGetter.get().canDogPassGate()) {
            centerType = BlockPathTypes.WALKABLE;
        }
        return super.m_164725_(x, y, z, floorLevel, maxUpStep, dir, centerType);
    }

    public BlockPathTypes m_8086_(BlockGetter getter, int x, int y, int z) {
        BlockState state;
        BlockPathTypes retType = super.m_8086_(getter, x, y, z);
        Dog dog = this.dogGetter.get();
        if (retType == BlockPathTypes.FENCE && dog.canDogPassGate() && (state = dog.m_9236_().m_8055_(new BlockPos(x, y, z))).m_60734_() instanceof FenceGateBlock) {
            retType = BlockPathTypes.WALKABLE;
        }
        if (retType == BlockPathTypes.DANGER_FIRE && !dog.m_20077_()) {
            BlockPos check_pos = new BlockPos(x, y - 1, z);
            BlockState state2 = dog.m_9236_().m_8055_(check_pos);
            if (!state2.m_60838_((BlockGetter)dog.m_9236_(), check_pos)) {
                retType = BlockPathTypes.DAMAGE_FIRE;
            }
        }
        return retType;
    }

    public Node m_230627_(int x, int y, int z) {
        Node ret = new Node(x, y, z);
        ret.f_77282_ = BlockPathTypes.OPEN;
        ret.f_77281_ = -1.0f;
        return ret;
    }

    protected boolean m_77626_(@Nullable Node neighbor, Node center) {
        if (neighbor != null && neighbor.f_77282_ == BlockPathTypes.OPEN) {
            return false;
        }
        return super.m_77626_(neighbor, center);
    }

    public static BlockPathTypes dogGetPathTypeFromState(BlockGetter getter, BlockPos pos) {
        return WalkNodeEvaluator.m_77643_((BlockGetter)getter, (BlockPos)pos);
    }
}

