/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DogPathNavigation
extends PathNavigation
implements IDogNavLock {
    private Dog dog;
    private boolean locked;
    private boolean moveInTargetNode = false;

    public DogPathNavigation(Dog dog, Level level) {
        super((Mob)dog, level);
        this.dog = dog;
    }

    public void m_7638_() {
        super.m_7638_();
        if (this.m_26571_() && this.f_26496_ != null && this.f_26496_.m_77392_()) {
            this.m_26573_();
        }
        this.setSneakIfNextNodesHasDanger();
    }

    protected void m_7636_() {
        boolean isCloseEnough;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        Vec3 currentPos = this.m_7475_();
        this.f_26505_ = 0.45f;
        BlockPos nextPos = this.f_26496_.m_77400_();
        double dx = Math.abs(this.f_26494_.m_20185_() - ((double)nextPos.m_123341_() + 0.5));
        double dy = Math.abs(this.f_26494_.m_20186_() - (double)nextPos.m_123342_());
        double dz = Math.abs(this.f_26494_.m_20189_() - ((double)nextPos.m_123343_() + 0.5));
        boolean bl = isCloseEnough = dx <= (double)this.f_26505_ && dy < 1.0 && dz <= (double)this.f_26505_;
        if (isCloseEnough) {
            this.f_26496_.m_77374_();
            this.checkDogAndMoveInTargetNodeWhenReach();
        }
        this.m_6481_(currentPos);
        this.dogCheckIfMissedFirstNodeAndMaybeSkip();
    }

    private void dogCheckIfMissedFirstNodeAndMaybeSkip() {
        boolean kinda_far_from_first_node;
        boolean missed_first_node;
        if (this.m_26571_()) {
            return;
        }
        Path path = this.m_26570_();
        if (path == null || path.m_77398_() < 2) {
            return;
        }
        boolean bl = missed_first_node = path.m_77399_() == 0;
        if (!missed_first_node) {
            return;
        }
        Node first_node = path.m_77375_(0);
        Node second_node = path.m_77375_(1);
        if (second_node.f_77282_ != BlockPathTypes.WALKABLE) {
            return;
        }
        double min_bb_clip = 0.1;
        double max_dist_from_first_node = 0.5 + (double)(this.dog.m_20205_() / 2.0f) - 0.1;
        double dog_dist_from_first_node_sqr = this.dog.m_20238_(new Vec3((double)first_node.f_77271_ + 0.5, this.dog.m_20186_(), (double)first_node.f_77273_ + 0.5));
        boolean bl2 = kinda_far_from_first_node = dog_dist_from_first_node_sqr > max_dist_from_first_node * max_dist_from_first_node;
        if (kinda_far_from_first_node) {
            return;
        }
        BlockPos bpos = this.dog.m_20183_();
        int y_diff = second_node.f_77272_ - bpos.m_123342_();
        if (y_diff > 0 || y_diff < -1) {
            return;
        }
        Vec3 pos = this.dog.m_20182_();
        Vec3 second_node_pos = Vec3.m_82539_((Vec3i)second_node.m_77288_());
        Vec3 dist_vec = pos.m_82546_(second_node_pos);
        double len_xz_sqr = dist_vec.f_82479_ * dist_vec.f_82479_ + dist_vec.f_82481_ * dist_vec.f_82481_;
        if (len_xz_sqr > 2.0) {
            return;
        }
        path.m_77374_();
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        boolean is_first_fence_node;
        Path path = this.f_26496_;
        if (path == null) {
            return true;
        }
        BlockPos nextPos = path.m_77400_();
        double dy = this.dog.m_20186_() - (double)nextPos.m_123342_();
        if (dy < -1.75) {
            this.m_26573_();
            return true;
        }
        Node nextNode = path.m_77401_();
        boolean bl = is_first_fence_node = nextNode.f_77282_ == BlockPathTypes.FENCE && path.m_77399_() == 0;
        if (!is_first_fence_node && this.dog.m_21439_(nextNode.f_77282_) < 0.0f) {
            this.m_26573_();
            return true;
        }
        return false;
    }

    private void checkDogAndMoveInTargetNodeWhenReach() {
        if (!this.moveInTargetNode) {
            return;
        }
        Path path = this.f_26496_;
        if (path == null) {
            return;
        }
        if (!path.m_77392_() || path.m_77398_() <= 0 || !path.m_77403_()) {
            return;
        }
        BlockPos target = path.m_77406_();
        Node end_node = path.m_77395_();
        if (target == null || end_node == null) {
            return;
        }
        if (end_node.m_77288_().equals((Object)target)) {
            return;
        }
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.m_9236_(), (BlockPos.MutableBlockPos)target.m_122032_());
        if (this.dog.m_21439_(type) < 0.0f) {
            return;
        }
        Node node = new Node(target.m_123341_(), target.m_123342_(), target.m_123343_());
        node.f_77282_ = type;
        this.f_26496_ = new Path(List.of(node), target, true);
    }

    private void setSneakIfNextNodesHasDanger() {
        Optional<Pair<Integer, Node>> result_optional = this.getNodesUntilDogApproachDanger();
        if (!result_optional.isPresent()) {
            return;
        }
        if (this.dog.isInLiquid()) {
            return;
        }
        Pair<Integer, Node> result = result_optional.get();
        int danger = (Integer)result.getLeft();
        float speed_cap = danger > 1 ? 0.4f : (danger == 1 ? 0.3f : 0.2f);
        this.dog.getDefaultMoveControl().forceSneak(speed_cap);
    }

    public Optional<Pair<Integer, Node>> getNodesUntilDogApproachDanger() {
        if (this.m_26571_()) {
            return Optional.empty();
        }
        Path path = this.m_26570_();
        if (path == null) {
            return Optional.empty();
        }
        if (path.m_77399_() >= path.m_77398_()) {
            return Optional.empty();
        }
        Pair ret = null;
        int start = path.m_77399_();
        int end = Math.min(start + 2, path.m_77398_() - 1);
        int prev_node_y = this.dog.m_20183_().m_123342_();
        for (int i = start; i <= end; ++i) {
            Node node = path.m_77375_(i);
            if (prev_node_y == node.f_77272_ && i < end) continue;
            prev_node_y = node.f_77272_;
            BlockPathTypes type = node.f_77282_;
            if (type == null || !DogUtil.isDangerPathType(type = this.dog.inferType(type, InferTypeContext.getDefault()))) continue;
            int danger = i - start;
            ret = danger >= 0 ? Pair.of((Object)danger, (Object)node) : null;
            break;
        }
        return Optional.ofNullable(ret);
    }

    public Optional<Node> getDogNextNode() {
        if (this.m_26571_()) {
            return Optional.empty();
        }
        Path path = this.m_26570_();
        if (path == null) {
            return Optional.empty();
        }
        int next_indx = path.m_77399_();
        if (next_indx >= path.m_77398_()) {
            return Optional.empty();
        }
        return Optional.of(path.m_77375_(next_indx));
    }

    public boolean shouldDogBlockFluidPush() {
        if (this.dog.m_20096_()) {
            return false;
        }
        return this.getDogNextNode().isPresent();
    }

    public void setDogMoveInTargetNode() {
        this.moveInTargetNode = true;
    }

    protected boolean m_7632_() {
        boolean ground_canUpdatePath = this.f_26494_.m_20096_() || this.m_26574_();
        return ground_canUpdatePath && !this.dog.isOnSwitchNavCooldown() && !this.locked;
    }

    public void m_26569_() {
        boolean prevLock = this.locked;
        this.locked = false;
        super.m_26569_();
        this.locked = prevLock;
    }

    public boolean m_26536_(@Nullable Path p_26537_, double p_26538_) {
        this.moveInTargetNode = false;
        return super.m_26536_(p_26537_, p_26538_);
    }

    public boolean m_6342_(BlockPos pos) {
        if (this.dog.m_5825_() && this.f_26495_.m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
            return true;
        }
        return super.m_6342_(pos);
    }

    protected PathFinder m_5532_(int p_26453_) {
        this.f_26508_ = new DogNodeEvaluator(this::getDog);
        this.f_26508_.m_77351_(true);
        return new PathFinder(this.f_26508_, p_26453_);
    }

    private Dog getDog() {
        return this.dog;
    }

    protected Vec3 m_7475_() {
        return DogPathNavigation.getTempDogPos(this.dog, this);
    }

    public static Vec3 getTempDogPos(Dog dog) {
        return DogPathNavigation.getTempDogPos(dog, dog.m_21573_());
    }

    public static Vec3 getTempDogPos(Dog dog, PathNavigation nav) {
        return new Vec3(dog.m_20185_(), (double)DogPathNavigation.getSurfaceY(dog, nav), dog.m_20189_());
    }

    private static int getSurfaceY(Dog dog, PathNavigation nav) {
        boolean do_float_y;
        boolean bl = do_float_y = dog.isInLiquid() && nav.m_26576_();
        if (!do_float_y) {
            return DogUtil.getSurfaceStandingInY(dog);
        }
        int y_block = dog.m_146904_();
        for (int y_offset = 0; y_offset <= 16; ++y_offset) {
            int check_y = y_block + y_offset;
            BlockPos check_pos = BlockPos.m_274561_((double)dog.m_20185_(), (double)check_y, (double)dog.m_20189_());
            BlockState check_state = dog.m_9236_().m_8055_(check_pos);
            if (!check_state.m_60819_().m_76178_()) continue;
            return check_y;
        }
        return y_block;
    }

    @Override
    public void lockDogNavigation() {
        this.locked = true;
    }

    @Override
    public void unlockDogNavigation() {
        this.locked = false;
    }

    @Nullable
    protected Path m_148222_(@Nonnull Set<BlockPos> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.m_148222_(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }
}

