/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGoAndCarryPlayerAction;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.CarryMeData;
import doggytalents.common.talent.WolfMountTalent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;

public class CarryMePacket
extends DogPacket<CarryMeData> {
    @Override
    public CarryMeData decode(FriendlyByteBuf buf) {
        return new CarryMeData(buf.readInt());
    }

    @Override
    public void handleDog(Dog dog, CarryMeData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer owner = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)owner)) {
            return;
        }
        if (owner.m_36335_().m_41519_((Item)DoggyItems.WHISTLE.get())) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.CARRY_ME_WHISTLE.get()).booleanValue()) {
            return;
        }
        if (owner.m_20280_((Entity)dog) > 144.0) {
            return;
        }
        if (!WolfMountTalent.isValidCarryMeDog(dog)) {
            return;
        }
        if (!WolfMountTalent.isValidCarryMeTarget((LivingEntity)owner)) {
            return;
        }
        dog.clearTriggerableAction();
        dog.triggerAction(new DogGoAndCarryPlayerAction(dog, (LivingEntity)owner));
        owner.m_9236_().m_5594_(null, owner.m_20183_(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + owner.m_9236_().f_46441_.m_188501_() * 0.1f, 0.4f + owner.m_9236_().f_46441_.m_188501_() * 0.2f);
        owner.m_213846_((Component)Component.m_237110_((String)"dogcommand.carry_me", (Object[])new Object[]{dog.m_7755_().getString()}));
        owner.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
    }
}

