/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.common.collect.AbstractIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class RingSearchIterator
extends AbstractIterator<BlockPos> {
    private final int range;
    private final BlockPos center;
    private final int yRange;
    private final boolean inflatingY;
    private final float startProgress;
    private int inflate = 0;
    private int startIndex = 0;
    private int index = 0;
    private int maxIndex = 0;
    private final BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
    private static final Vec3i[] STAGE_MOVES = new Vec3i[]{new Vec3i(1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(0, 0, -1)};

    public static Iterable<BlockPos> create(BlockPos center, int y, int range, boolean inflatingY) {
        return () -> new RingSearchIterator(center, y, range, inflatingY, 0.0f);
    }

    public static Iterable<BlockPos> createWithRandom(BlockPos center, int y, int range, boolean inflatingY, RandomSource rand) {
        float r = rand.m_188501_();
        return () -> new RingSearchIterator(center, y, range, inflatingY, r);
    }

    private RingSearchIterator(BlockPos center, int y, int range, boolean inflatingY, float startProgress) {
        this.range = range;
        this.yRange = y;
        this.center = center;
        this.inflatingY = inflatingY;
        this.cursor.m_122178_(0, 0, 0);
        this.startProgress = startProgress;
    }

    protected BlockPos computeNext() {
        int max_y;
        if (this.inflate > this.range) {
            return (BlockPos)this.endOfData();
        }
        BlockPos ret = this.center.m_121955_((Vec3i)this.cursor.m_7949_());
        int y = this.cursor.m_123342_();
        int n = max_y = this.inflatingY ? Math.min(this.yRange, this.inflate) : this.yRange;
        if (y < max_y) {
            this.cursor.m_142448_(y >= 0 ? -(y + 1) : -y);
            return ret;
        }
        int stage = this.inflate == 0 ? 0 : this.index / (this.inflate * 2);
        this.cursor.m_122193_(STAGE_MOVES[stage]).m_142448_(0);
        this.advanceIndex();
        if (this.index == this.startIndex) {
            ++this.inflate;
            this.maxIndex = this.inflate * 2 * 4 - 1;
            this.index = this.startIndex = Mth.m_14045_((int)Mth.m_14143_((float)(this.startProgress * (float)(this.maxIndex + 1))), (int)0, (int)this.maxIndex);
            this.cursor.m_122178_(-this.inflate, 0, -this.inflate);
            this.moveToStartIndex();
        }
        return ret;
    }

    private void moveToStartIndex() {
        if (this.startIndex <= 0) {
            return;
        }
        int stage = this.startIndex / (this.inflate * 2);
        int odd_move = this.startIndex % (this.inflate * 2);
        for (int i = 0; i < stage; ++i) {
            this.cursor.m_122193_(STAGE_MOVES[i].m_142393_(this.inflate * 2));
        }
        this.cursor.m_122193_(STAGE_MOVES[stage].m_142393_(odd_move));
    }

    private void advanceIndex() {
        ++this.index;
        if (this.index > this.maxIndex) {
            this.index = 0;
        }
    }
}

