/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.xnet.modules.controller.client.GuiController;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JeiGhostIngredientHandler<GUI extends GenericGuiContainer<?, ?>>
implements IGhostIngredientHandler<GUI> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(GUI gui, ITypedIngredient<I> ingredient, boolean b) {
        Optional optionalItemStack = ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
        if (optionalItemStack.isEmpty()) {
            return ImmutableList.of();
        }
        ItemStack itemStack = (ItemStack)optionalItemStack.get();
        if (itemStack.m_41619_()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (gui instanceof GuiController) {
            GuiController guiController = (GuiController)((Object)gui);
            for (Widget widget : guiController.getConnectorEditPanel().getChildren()) {
                if (!(widget instanceof BlockRender)) continue;
                BlockRender blockRender = (BlockRender)widget;
                builder.add((Object)new GhostSlotTarget(blockRender, (GuiController)((Object)gui)));
            }
        }
        return builder.build();
    }

    public void onComplete() {
    }

    private static class GhostSlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        public static final int SIDE_WIDTH = 80;
        final BlockRender slot;
        final GuiController gui;
        Rect2i area;
        int lastGuiLeft;
        int lastGuiTop;

        public GhostSlotTarget(BlockRender slot, GuiController gui) {
            this.slot = slot;
            this.gui = gui;
            this.initRectangle();
        }

        private void initRectangle() {
            Panel connectorEditPanel = this.gui.getConnectorEditPanel();
            int pointX = connectorEditPanel.getBounds().x + this.slot.getBounds().x - 80;
            int pointY = connectorEditPanel.getBounds().y + this.slot.getBounds().y;
            this.area = new Rect2i(this.gui.getGuiLeft() + pointX, this.gui.getGuiTop() + pointY, 16, 16);
            this.lastGuiLeft = this.gui.getGuiLeft();
            this.lastGuiTop = this.gui.getGuiTop();
        }

        @NotNull
        public Rect2i getArea() {
            if (this.lastGuiLeft != this.gui.getGuiLeft() || this.lastGuiTop != this.gui.getGuiTop()) {
                this.initRectangle();
            }
            return this.area;
        }

        public void accept(@NotNull ItemStack ingredient) {
            this.slot.fireDraggedEvents(ingredient);
        }
    }
}

