/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.client;

import java.util.HashMap;
import java.util.Map;
import mcjty.xnet.modules.cables.ConnectorType;

public class CablePatterns {
    static final Map<Pattern, QuadSetting> PATTERNS = new HashMap<Pattern, QuadSetting>();

    public static QuadSetting findPattern(ConnectorType s1, ConnectorType s2, ConnectorType s3, ConnectorType s4) {
        return PATTERNS.get(new Pattern(s1 != ConnectorType.NONE, s2 != ConnectorType.NONE, s3 != ConnectorType.NONE, s4 != ConnectorType.NONE));
    }

    public static class Pattern {
        private final boolean s1;
        private final boolean s2;
        private final boolean s3;
        private final boolean s4;

        public Pattern(boolean s1, boolean s2, boolean s3, boolean s4) {
            this.s1 = s1;
            this.s2 = s2;
            this.s3 = s3;
            this.s4 = s4;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pattern pattern = (Pattern)o;
            return this.s1 == pattern.s1 && this.s2 == pattern.s2 && this.s3 == pattern.s3 && this.s4 == pattern.s4;
        }

        public int hashCode() {
            int result = this.s1 ? 1 : 0;
            result = 31 * result + (this.s2 ? 1 : 0);
            result = 31 * result + (this.s3 ? 1 : 0);
            result = 31 * result + (this.s4 ? 1 : 0);
            return result;
        }
    }

    public static class QuadSetting {
        private final SpriteIdx sprite;
        private final int rotation;

        public QuadSetting(SpriteIdx sprite, int rotation) {
            this.rotation = rotation;
            this.sprite = sprite;
        }

        public SpriteIdx getSprite() {
            return this.sprite;
        }

        public int getRotation() {
            return this.rotation;
        }
    }

    public static enum SpriteIdx {
        SPRITE_NONE,
        SPRITE_END,
        SPRITE_STRAIGHT,
        SPRITE_CORNER,
        SPRITE_THREE,
        SPRITE_CROSS;

    }
}

