/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.utils;

import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.xnet.apiimpl.enums.ChannelMode;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.apiimpl.items.enums.ExtractMode;
import mcjty.xnet.apiimpl.items.enums.StackMode;
import mcjty.xnet.apiimpl.logic.enums.LogicFilter;
import mcjty.xnet.apiimpl.logic.enums.LogicMode;
import mcjty.xnet.apiimpl.logic.enums.Operator;
import mcjty.xnet.apiimpl.logic.enums.SensorMode;
import net.minecraft.world.item.ItemStack;

public class CastTools {
    public static Color safeColor(Object o) {
        if (o != null) {
            return Color.colorByValue((int)((Integer)o));
        }
        return Color.OFF;
    }

    public static boolean safeBoolean(Object o) {
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    public static LogicFilter safeLogicFilter(Object o) {
        if (o != null) {
            return LogicFilter.values()[(Integer)o];
        }
        return LogicFilter.DIRECT;
    }

    public static int safeInt(Object o) {
        return CastTools.safeIntOrValue(o, 0);
    }

    public static int safeIntOrValue(Object o, int value) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception ignored) {
                return value;
            }
        }
        return value;
    }

    public static ChannelMode safeChannelMode(Object o) {
        if (o != null) {
            return ChannelMode.values()[(Integer)o];
        }
        return ChannelMode.PRIORITY;
    }

    public static InsExtMode safeInsExtMode(Object o) {
        if (o != null) {
            return InsExtMode.values()[(Integer)o];
        }
        return InsExtMode.INS;
    }

    public static ItemStack safeItemStack(Object o) {
        if (o != null) {
            return (ItemStack)o;
        }
        return ItemStack.f_41583_;
    }

    public static ExtractMode safeExtractMode(Object o) {
        if (o != null) {
            return ExtractMode.values()[(Integer)o];
        }
        return ExtractMode.FIRST;
    }

    public static StackMode safeStackMode(Object o) {
        if (o != null) {
            return StackMode.values()[(Integer)o];
        }
        return StackMode.SINGLE;
    }

    public static LogicMode safeLogicMode(Object o) {
        if (o != null) {
            return LogicMode.values()[(Integer)o];
        }
        return LogicMode.SENSOR;
    }

    public static SensorMode safeSensorMode(Object o) {
        if (o != null) {
            return SensorMode.values()[(Integer)o];
        }
        return SensorMode.OFF;
    }

    public static Operator safeOperator(Object o) {
        if (o != null) {
            return Operator.valueOfCode(((String)o).toUpperCase());
        }
        return Operator.EQUAL;
    }
}

