/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.SourceTag;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class FluidMappingsRegistry {
    private static final Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, Coolant>> s_fluidToCoolant = new Object2ObjectArrayMap(4);
    private static final Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, Vapor>> s_fluidToVapor = new Object2ObjectArrayMap(4);
    private static final Map<Coolant, List<IMapping<Coolant, TagKey<Fluid>>>> s_coolantToFluid = new Object2ObjectArrayMap(4);
    private static final Map<Vapor, List<IMapping<Vapor, TagKey<Fluid>>>> s_vaporToFluid = new Object2ObjectArrayMap(4);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/FluidMappingsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean hasCoolantFrom(Fluid stack) {
        return FluidMappingsRegistry.getCoolantFrom(stack).isPresent();
    }

    public static boolean hasVaporFrom(Fluid stack) {
        return FluidMappingsRegistry.getVaporFrom(stack).isPresent();
    }

    public static Optional<IMapping<TagKey<Fluid>, Coolant>> getCoolantFrom(Fluid fluid) {
        return FluidMappingsRegistry.getFrom(s_fluidToCoolant, fluid);
    }

    public static Optional<IMapping<TagKey<Fluid>, Vapor>> getVaporFrom(Fluid fluid) {
        return FluidMappingsRegistry.getFrom(s_fluidToVapor, fluid);
    }

    public static Optional<List<IMapping<Coolant, TagKey<Fluid>>>> getFluidFrom(Coolant coolant) {
        return Optional.ofNullable(s_coolantToFluid.get(coolant));
    }

    public static Optional<List<IMapping<Vapor, TagKey<Fluid>>>> getFluidFrom(Vapor vapor) {
        return Optional.ofNullable(s_vaporToFluid.get(vapor));
    }

    public static void registerCoolantMapping(String name, int quantity, String sourceFluidTagId) {
        FluidMappingsRegistry.registerCoolantMapping(name, quantity, (TagKey<Fluid>)TagsHelper.FLUIDS.createKey(sourceFluidTagId));
    }

    public static void registerCoolantMapping(String name, int quantity, TagKey<Fluid> sourceFluidTag) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkNotNull(sourceFluidTag);
        InternalDispatcher.dispatch("fluid-mapping-register", () -> {
            int qty;
            if (quantity < 0) {
                qty = 1;
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Using default quantity for Coolant {} instead of the provided, invalid, one: {}", (Object)name, (Object)qty);
            } else {
                qty = quantity;
            }
            FluidsRegistry.getCoolant(name).ifPresentOrElse(coolant -> {
                IMapping<TagKey, Coolant> mapping = IMapping.of(sourceFluidTag, 1, coolant, qty);
                s_fluidToCoolant.put((TagKey<Fluid>)mapping.getSource(), mapping);
                s_coolantToFluid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
            }, () -> ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source Coolant: {}", (Object)name));
        });
    }

    public static void removeCoolantMapping(TagKey<Fluid> sourceFluidTag) {
        FluidMappingsRegistry.removeSourceMapping(sourceFluidTag, s_fluidToCoolant, s_coolantToFluid);
    }

    public static void removeCoolantMapping(String sourceFluidTagId) {
        FluidMappingsRegistry.removeSourceMapping(sourceFluidTagId, s_fluidToCoolant, s_coolantToFluid);
    }

    public static void registerVaporMapping(String name, int quantity, String sourceFluidTagId) {
        FluidMappingsRegistry.registerVaporMapping(name, quantity, (TagKey<Fluid>)TagsHelper.FLUIDS.createKey(sourceFluidTagId));
    }

    public static void registerVaporMapping(String name, int quantity, TagKey<Fluid> sourceFluidTag) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkNotNull(sourceFluidTag);
        InternalDispatcher.dispatch("fluid-mapping-register", () -> {
            int qty;
            if (quantity < 0) {
                qty = 1;
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Using default quantity for Vapor {} instead of the provided, invalid, one: {}", (Object)name, (Object)qty);
            } else {
                qty = quantity;
            }
            FluidsRegistry.getVapor(name).ifPresentOrElse(vapor -> {
                IMapping<TagKey, Vapor> mapping = IMapping.of(sourceFluidTag, 1, vapor, qty);
                s_fluidToVapor.put((TagKey<Fluid>)mapping.getSource(), mapping);
                s_vaporToFluid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
            }, () -> ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source Vapor: {}", (Object)name));
        });
    }

    public static void removeVaporMapping(TagKey<Fluid> sourceFluidTag) {
        FluidMappingsRegistry.removeSourceMapping(sourceFluidTag, s_fluidToVapor, s_vaporToFluid);
    }

    public static void removeVaporMapping(String sourceFluidTagId) {
        FluidMappingsRegistry.removeSourceMapping(sourceFluidTagId, s_fluidToVapor, s_vaporToFluid);
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        FluidMappingsRegistry.processWrapper("Coolants", wrapper.CoolantSources, s_fluidToCoolant, s_coolantToFluid, FluidMappingsRegistry::removeCoolantMapping, source -> FluidMappingsRegistry.registerCoolantMapping(source.ProductName, source.ProductQuantity, source.SourceTagId));
        FluidMappingsRegistry.processWrapper("Vapors", wrapper.VaporSources, s_fluidToVapor, s_vaporToFluid, FluidMappingsRegistry::removeVaporMapping, source -> FluidMappingsRegistry.registerVaporMapping(source.ProductName, source.ProductQuantity, source.SourceTagId));
    }

    public static Map<Coolant, List<IMapping<Coolant, TagKey<Fluid>>>> getCoolantToFluidMap() {
        return FluidMappingsRegistry.unmodifiableInverseMap(s_coolantToFluid);
    }

    public static Map<Vapor, List<IMapping<Vapor, TagKey<Fluid>>>> getVaporToFluidMap() {
        return FluidMappingsRegistry.unmodifiableInverseMap(s_vaporToFluid);
    }

    private FluidMappingsRegistry() {
    }

    private static <T> Optional<IMapping<TagKey<Fluid>, T>> getFrom(Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, T>> map, Fluid fluid) {
        List tags = TagsHelper.FLUIDS.getTags((Object)fluid);
        return map.entrySet().stream().filter(entry -> tags.contains(entry.getKey())).map(Map.Entry::getValue).findAny();
    }

    private static <X> void removeSourceMapping(String sourceFluidTagId, Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, X>> fluidToX, Map<X, List<IMapping<X, TagKey<Fluid>>>> xToFluid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceFluidTagId) ? 1 : 0) != 0);
        FluidMappingsRegistry.removeSourceMapping((TagKey<Fluid>)TagsHelper.FLUIDS.createKey(sourceFluidTagId), fluidToX, xToFluid);
    }

    private static <X> void removeSourceMapping(TagKey<Fluid> sourceFluidTag, Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, X>> fluidToX, Map<X, List<IMapping<X, TagKey<Fluid>>>> xToFluid) {
        Preconditions.checkNotNull(sourceFluidTag);
        Preconditions.checkNotNull(fluidToX);
        Preconditions.checkNotNull(xToFluid);
        InternalDispatcher.dispatch("fluid-mapping-remove", () -> {
            IMapping removedMapping = (IMapping)fluidToX.remove(sourceFluidTag);
            if (null != removedMapping) {
                xToFluid.getOrDefault(removedMapping.getProduct(), Collections.emptyList()).removeIf(xToTagMapping -> ((TagKey)xToTagMapping.getProduct()).equals((Object)sourceFluidTag));
                xToFluid.entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(xToFluid::remove);
            }
        });
    }

    private static <X> void processWrapper(String objectName, AddRemoveSection<SourceTag> wrapperSection, Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, X>> fluidToX, Map<X, List<IMapping<X, TagKey<Fluid>>>> xToFluid, Consumer<String> removeAction, Consumer<SourceTag> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} sources", (Object)objectName);
            fluidToX.clear();
            xToFluid.clear();
        } else {
            wrapperSection.removals().filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        wrapperSection.additions().filter(Objects::nonNull).forEach(addAction);
    }

    private static <T> Map<T, List<IMapping<T, TagKey<Fluid>>>> unmodifiableInverseMap(Map<T, List<IMapping<T, TagKey<Fluid>>>> map) {
        Object2ObjectArrayMap copy = new Object2ObjectArrayMap(map.size());
        for (Map.Entry<T, List<IMapping<T, TagKey<Fluid>>>> entry : map.entrySet()) {
            copy.put(entry.getKey(), (Object)new ObjectArrayList((Collection)entry.getValue()));
        }
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)copy);
    }
}

