/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractEnergyGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockFluidGeneratorVariant;
import it.zerono.mods.zerocore.base.multiblock.part.io.IIOPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPort;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class AbstractFluidGeneratorMultiblockController<Controller extends AbstractFluidGeneratorMultiblockController<Controller, V>, V extends IMultiblockFluidGeneratorVariant>
extends AbstractEnergyGeneratorMultiblockController<Controller, V> {
    public AbstractFluidGeneratorMultiblockController(Level world) {
        super(world);
    }

    public abstract Optional<IFluidHandler> getLiquidHandler();

    public abstract Optional<IFluidHandler> getGasHandler();

    public abstract Optional<IFluidHandler> getFluidHandler(IoDirection var1);

    protected static int distributeFluidEqually(FluidStack availableFluid, Collection<? extends IFluidPort> coolantPorts) {
        if (availableFluid.isEmpty() || coolantPorts.isEmpty()) {
            return 0;
        }
        int fluidPerPort = availableFluid.getAmount() / coolantPorts.size();
        return coolantPorts.stream().filter(p -> p.getIoDirection().isOutput()).map(IFluidPort::getFluidPortHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToInt(handler -> handler.outputFluid(new FluidStack(availableFluid, fluidPerPort))).sum();
    }

    protected static int acquireFluidEqually(IFluidHandler destination, int maxAmount, Collection<? extends IFluidPort> coolantPorts) {
        if (maxAmount <= 0 || coolantPorts.isEmpty()) {
            return 0;
        }
        int fluidPerPort = maxAmount / coolantPorts.size();
        return coolantPorts.stream().filter(p -> p.getIoDirection().isInput()).map(IFluidPort::getFluidPortHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToInt(handler -> handler.inputFluid(destination, fluidPerPort)).sum();
    }
}

