/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.FluidMappingsRegistry;
import it.zerono.mods.extremereactors.api.coolant.TransitionsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainerAccess;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockFluidGeneratorVariant;
import it.zerono.mods.zerocore.lib.TestResult;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IndexedStackContainer;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.data.stack.StackAdapters;
import it.zerono.mods.zerocore.lib.fluid.handler.IndexedFluidHandlerForwarder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.tag.TagSource;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidContainer
extends IndexedStackContainer<FluidType, Fluid, FluidStack>
implements IFluidContainer {
    private static final Cache<Vapor, Fluid> s_vaporizationCache = CacheBuilder.newBuilder().initialCapacity(4).concurrencyLevel(2).maximumSize(64L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Cache<Coolant, Fluid> s_condensationCache = CacheBuilder.newBuilder().initialCapacity(4).concurrencyLevel(2).maximumSize(64L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final IFluidContainerAccess _accessGovernor;
    private Map<FluidType, IndexedFluidHandlerForwarder<FluidType>> _wrappers;
    private int _liquidVaporizedLastTick;
    private Coolant _cachedCoolant;
    private Vapor _cachedVapor;
    private IMapping<Coolant, Vapor> _cachedVaporization;
    private IMapping<Vapor, Coolant> _cachedCondensation;

    public FluidContainer(IFluidContainerAccess accessGovernor) {
        super(0, StackAdapters.FLUIDSTACK, (Enum)FluidType.Gas, (Enum)FluidType.Liquid, (Enum[])new FluidType[0]);
        this._accessGovernor = accessGovernor;
        this._liquidVaporizedLastTick = 0;
    }

    public void reset() {
        this._liquidVaporizedLastTick = 0;
        this.voidGas();
        this.voidLiquid();
    }

    @Override
    public Optional<Fluid> getGas() {
        return this.getContent(FluidType.Gas);
    }

    @Override
    public Optional<Fluid> getLiquid() {
        return this.getContent(FluidType.Liquid);
    }

    public <T> T mapLiquid(Function<Fluid, T> mapper, T defaultValue) {
        return (T)this.map(FluidType.Liquid, mapper, defaultValue);
    }

    public <T> T mapLiquidAmount(IntFunction<T> mapper, T defaultValue) {
        return (T)this.map(FluidType.Liquid, mapper, defaultValue);
    }

    public <T> T mapLiquid(BiFunction<Fluid, Integer, T> mapper, T defaultValue) {
        return (T)this.map(FluidType.Liquid, mapper, defaultValue);
    }

    public <T> T mapGas(Function<Fluid, T> mapper, T defaultValue) {
        return (T)this.map(FluidType.Gas, mapper, defaultValue);
    }

    public <T> T mapGasAmount(IntFunction<T> mapper, T defaultValue) {
        return (T)this.map(FluidType.Gas, mapper, defaultValue);
    }

    public <T> T mapGas(BiFunction<Fluid, Integer, T> mapper, T defaultValue) {
        return (T)this.map(FluidType.Gas, mapper, defaultValue);
    }

    public void forLiquid(Consumer<Fluid> consumer) {
        this.accept(FluidType.Liquid, consumer);
    }

    public void forLiquid(IntConsumer consumer) {
        this.accept(FluidType.Liquid, consumer);
    }

    public void forLiquid(BiConsumer<Fluid, Integer> consumer) {
        this.accept(FluidType.Liquid, consumer);
    }

    public void forGas(Consumer<Fluid> consumer) {
        this.accept(FluidType.Gas, consumer);
    }

    public void forGas(IntConsumer consumer) {
        this.accept(FluidType.Gas, consumer);
    }

    public void forGas(BiConsumer<Fluid, Integer> consumer) {
        this.accept(FluidType.Gas, consumer);
    }

    @Override
    public int getGasAmount() {
        return this.getContentAmount(FluidType.Gas);
    }

    @Override
    public int getLiquidAmount() {
        return this.getContentAmount(FluidType.Liquid);
    }

    public int insertLiquid(Fluid liquid, int amount, OperationMode mode) {
        return amount <= 0 ? 0 : this.insert(FluidType.Liquid, liquid, amount, mode);
    }

    public int voidGas() {
        return ((FluidStack)this.clear(FluidType.Gas)).getAmount();
    }

    public int voidLiquid() {
        return ((FluidStack)this.clear(FluidType.Liquid)).getAmount();
    }

    @Override
    public IFluidHandler getWrapper(IoDirection portDirection) {
        if (null == this._wrappers) {
            this._wrappers = Maps.newHashMap();
        }
        return (IFluidHandler)this._wrappers.computeIfAbsent(this._accessGovernor.getFluidTypeFrom(portDirection), idx -> new IndexedFluidHandlerForwarder((IndexedStackContainer)this, (Enum)idx, this._accessGovernor.getAllowedActionFor((FluidType)((Object)idx))));
    }

    public boolean isStackValidForIndex(FluidType index, FluidStack stack) {
        return !stack.isEmpty() && this.isContentValidForIndex(index, stack.getFluid());
    }

    public boolean isContentValidForIndex(FluidType index, Fluid content) {
        TestResult result = TestResult.from(this.getContent(index).map(fluid -> fluid.m_6212_(content)));
        if (!result.wasSkipped()) {
            return result.getAsBoolean();
        }
        Predicate<Fluid> test = index.isGas() ? FluidMappingsRegistry::hasVaporFrom : FluidMappingsRegistry::hasCoolantFrom;
        return TestResult.from(test, (Object)content).getAsBoolean();
    }

    @Override
    public Optional<Coolant> getCoolant() {
        return null == this._cachedCoolant || Coolant.EMPTY == this._cachedCoolant ? Optional.empty() : Optional.of(this._cachedCoolant);
    }

    @Override
    public Optional<Vapor> getVapor() {
        return null == this._cachedVapor || Vapor.EMPTY == this._cachedVapor ? Optional.empty() : Optional.of(this._cachedVapor);
    }

    @Override
    public <T> T mapCoolant(Function<Coolant, T> mapper, T defaultValue) {
        return null == this._cachedCoolant || Coolant.EMPTY == this._cachedCoolant ? defaultValue : mapper.apply(this._cachedCoolant);
    }

    @Override
    public <T> T mapVapor(Function<Vapor, T> mapper, T defaultValue) {
        return null == this._cachedVapor || Vapor.EMPTY == this._cachedVapor ? defaultValue : mapper.apply(this._cachedVapor);
    }

    @Override
    public FluidStackData getCoolantStackData(int sampleFrequency, ModContainer container, boolean isClientSide) {
        return FluidStackData.sampled((int)sampleFrequency, (ModContainer)container, (boolean)isClientSide, () -> () -> (FluidStack)this.getStack(FluidType.Liquid));
    }

    @Override
    public FluidStackData getVaporStackData(int sampleFrequency, ModContainer container, boolean isClientSide) {
        return FluidStackData.sampled((int)sampleFrequency, (ModContainer)container, (boolean)isClientSide, () -> () -> (FluidStack)this.getStack(FluidType.Gas));
    }

    @Override
    public int getLiquidVaporizedLastTick() {
        return this._liquidVaporizedLastTick;
    }

    @Override
    public double getLiquidTemperature(double reactorTemperature) {
        return this.getLiquidAmount() > 0 ? Math.min(reactorTemperature, (double)this.getCurrentCoolant().getBoilingPoint()) : reactorTemperature;
    }

    @Override
    public double onAbsorbHeat(double energyAbsorbed, IMultiblockFluidGeneratorVariant variant) {
        if (energyAbsorbed <= 0.0 || this.getLiquidAmount() <= 0) {
            return energyAbsorbed;
        }
        return this.mapLiquidAmount(amount -> this.absorbHeat(energyAbsorbed, variant, amount, this.getCurrentVaporization()), energyAbsorbed);
    }

    @Override
    public int onCondensation(int vaporUsed, boolean ventAllCoolant, IMultiblockFluidGeneratorVariant variant) {
        if (vaporUsed <= 0 || this.getGasAmount() <= 0) {
            return vaporUsed;
        }
        this.extract(FluidType.Gas, vaporUsed, OperationMode.Execute);
        if (ventAllCoolant) {
            return 0;
        }
        return this.mapGasAmount(amount -> this.condensate(vaporUsed, this.getCurrentCondensation()), vaporUsed);
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (syncReason.isFullSync()) {
            this.rebuildCoolantCache();
            this.rebuildVaporCache();
        }
    }

    private double absorbHeat(double energyAbsorbed, IMultiblockFluidGeneratorVariant variant, int liquidAmount, IMapping<Coolant, Vapor> vaporization) {
        if (this.getGasAmount() > 0) {
            if (!this.getCurrentVapor().equals(vaporization.getProduct())) {
                return energyAbsorbed;
            }
            return this.mapGas((Fluid gas) -> this.vaporize(energyAbsorbed, variant, vaporization, liquidAmount, (Fluid)gas), Double.valueOf(energyAbsorbed));
        }
        return FluidContainer.getVaporizationResult(vaporization.getProduct()).map(gas -> this.vaporize(energyAbsorbed, variant, vaporization, liquidAmount, (Fluid)gas)).orElse(energyAbsorbed);
    }

    private double vaporize(double energyAbsorbed, IMultiblockFluidGeneratorVariant variant, IMapping<Coolant, Vapor> vaporization, int availableLiquidAmount, Fluid targetGas) {
        IMapping<Vapor, Coolant> condensation = vaporization.getReverse();
        Coolant coolant = vaporization.getSource();
        double enthalpyOfVaporization = coolant.getEnthalpyOfVaporization();
        int maxVaporGenerable = this.getFreeSpace(FluidType.Gas);
        int maxLiquidVaporizable = condensation.getSourceAmount(maxVaporGenerable);
        int liquidVaporized = Math.min(maxLiquidVaporizable, availableLiquidAmount);
        int vaporGenerated = Math.min(vaporization.getProductAmount(liquidVaporized), (int)(energyAbsorbed / enthalpyOfVaporization));
        liquidVaporized = condensation.getSourceAmount(vaporGenerated);
        vaporGenerated = (int)((float)vaporGenerated * variant.getVaporGenerationEfficiency());
        if (liquidVaporized < 1) {
            return energyAbsorbed;
        }
        this._liquidVaporizedLastTick = liquidVaporized;
        this.extract(FluidType.Liquid, liquidVaporized, OperationMode.Execute);
        this.insert(FluidType.Gas, targetGas, vaporGenerated, OperationMode.Execute);
        return Math.max(0.0, energyAbsorbed - (double)liquidVaporized * enthalpyOfVaporization);
    }

    public int condensate(int vaporUsed, IMapping<Vapor, Coolant> condensation) {
        if (this.getLiquidAmount() > 0) {
            if (!this.getCurrentCoolant().equals(condensation.getProduct())) {
                return vaporUsed;
            }
            return this.mapLiquid((Fluid liquid) -> this.condensate(vaporUsed, condensation, (Fluid)liquid), Integer.valueOf(vaporUsed));
        }
        return FluidContainer.getCondensationResult(condensation.getProduct()).map(liquid -> this.condensate(vaporUsed, condensation, (Fluid)liquid)).orElse(vaporUsed);
    }

    public int condensate(int vaporUsed, IMapping<Vapor, Coolant> condensation, Fluid targetLiquid) {
        return this.insert(FluidType.Liquid, new FluidStack(targetLiquid, condensation.getProductAmount(vaporUsed)), OperationMode.Execute);
    }

    protected Coolant getCurrentCoolant() {
        if (null == this._cachedCoolant || Coolant.EMPTY == this._cachedCoolant) {
            this._cachedCoolant = this.getLiquid().flatMap(FluidMappingsRegistry::getCoolantFrom).map(IMapping::getProduct).orElse(Coolant.EMPTY);
        }
        return this._cachedCoolant;
    }

    protected IMapping<Coolant, Vapor> getCurrentVaporization() {
        if (null == this._cachedVaporization || TransitionsRegistry.EMPTY_VAPORIZATION == this._cachedVaporization) {
            this._cachedVaporization = TransitionsRegistry.get(this.getCurrentCoolant()).orElse(TransitionsRegistry.EMPTY_VAPORIZATION);
        }
        return this._cachedVaporization;
    }

    protected Vapor getCurrentVapor() {
        if (null == this._cachedVapor || Vapor.EMPTY == this._cachedVapor) {
            this._cachedVapor = this.getGas().flatMap(FluidMappingsRegistry::getVaporFrom).map(IMapping::getProduct).orElse(Vapor.EMPTY);
        }
        return this._cachedVapor;
    }

    protected IMapping<Vapor, Coolant> getCurrentCondensation() {
        if (null == this._cachedCondensation || TransitionsRegistry.EMPTY_CONDENSATION == this._cachedCondensation) {
            this._cachedCondensation = TransitionsRegistry.get(this.getCurrentVapor()).orElse(TransitionsRegistry.EMPTY_CONDENSATION);
        }
        return this._cachedCondensation;
    }

    private void resetCoolantCache() {
        this._cachedCoolant = null;
        this._cachedCondensation = null;
    }

    private void rebuildCoolantCache() {
        this.getCurrentCoolant();
        this.getCurrentVaporization();
    }

    private void resetVaporCache() {
        this._cachedVapor = null;
        this._cachedCondensation = null;
    }

    private void rebuildVaporCache() {
        this.getCurrentVapor();
        this.getCurrentCondensation();
    }

    protected void onInsert(FluidType fluidType, boolean wasEmpty) {
        super.onInsert((Enum)fluidType, wasEmpty);
        if (wasEmpty) {
            switch (fluidType) {
                case Liquid: {
                    this.rebuildCoolantCache();
                    break;
                }
                case Gas: {
                    this.rebuildVaporCache();
                }
            }
        }
    }

    protected void onExtract(FluidType fluidType, boolean isEmptyNow) {
        super.onExtract((Enum)fluidType, isEmptyNow);
        if (isEmptyNow) {
            switch (fluidType) {
                case Liquid: {
                    this.resetCoolantCache();
                    break;
                }
                case Gas: {
                    this.resetVaporCache();
                }
            }
        }
    }

    private static <T> Optional<Fluid> getTransitionResult(T transition, Cache<T, Fluid> cache, NonNullFunction<T, Optional<List<IMapping<T, TagKey<Fluid>>>>> mappingGetter) {
        Fluid result = (Fluid)cache.getIfPresent(transition);
        if (null == result) {
            Optional<Fluid> fluid = ((Optional)mappingGetter.apply(transition)).map(list -> (IMapping)list.get(0)).map(IMapping::getProduct).flatMap(arg_0 -> ((TagSource)TagsHelper.FLUIDS).getFirstObject(arg_0));
            if (fluid.isPresent()) {
                cache.put(transition, (Object)((Fluid)fluid.get()));
                return fluid;
            }
        }
        return Optional.ofNullable(result);
    }

    private static Optional<Fluid> getVaporizationResult(Vapor vapor) {
        return FluidContainer.getTransitionResult(vapor, s_vaporizationCache, FluidMappingsRegistry::getFluidFrom);
    }

    private static Optional<Fluid> getCondensationResult(Coolant coolant) {
        return FluidContainer.getTransitionResult(coolant, s_condensationCache, FluidMappingsRegistry::getFluidFrom);
    }
}

