/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.OperationalMode;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.WasteEjectionSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.IReactorControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.data.ReactantStackData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControllerEntity;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.BooleanData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.DoubleData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.EnumData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FloatData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IntData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.WideAmountData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class ReactorControllerContainer
extends ModTileContainer<ReactorControllerEntity>
implements IReactorControllerContainer {
    private final IntData _reactantCapacity;
    private final IntData _fluidCapacity;
    private final WideAmount _energyCapacity;
    private final IntData _fuelRodsCount;
    private final OperationalMode _reactorMode;
    private final EnergySystem _outputEnergySystem;
    private final BooleanData _active;
    private final DoubleData _coreHeat;
    private final DoubleData _casingHeat;
    private final FloatData _fuelConsumedLastTick;
    private final FloatData _fuelRichness;
    private final DoubleData _generatedLastTick;
    private final WideAmountData _energyStored;
    private final ReactantStackData _fuelStack;
    private final ReactantStackData _wasteStack;
    private final FluidStackData _coolantStack;
    private final FluidStackData _vaporStack;
    private final EnumData<WasteEjectionSetting> _wasteEjectionSetting;

    public ReactorControllerContainer(int windowId, Inventory playerInventory, ReactorControllerEntity controller) {
        super(3, ContainerFactory.EMPTY, (MenuType)Content.ContainerTypes.REACTOR_CONTROLLER.get(), windowId, playerInventory, (AbstractModBlockEntity)controller);
        MultiblockReactor reactor = (MultiblockReactor)controller.getMultiblockController().orElseThrow(IllegalStateException::new);
        boolean isClientSide = reactor.getWorld().m_5776_();
        this._reactorMode = reactor.getOperationalMode();
        this._outputEnergySystem = reactor.getOutputEnergySystem();
        this._reactantCapacity = IntData.immutable((ModContainer)this, (boolean)isClientSide, (int)reactor.getCapacity());
        this._fluidCapacity = IntData.immutable((ModContainer)this, (boolean)isClientSide, (int)reactor.getFluidContainer().getCapacity());
        this._energyCapacity = reactor.getCapacity(this._outputEnergySystem);
        this._fuelRodsCount = IntData.immutable((ModContainer)this, (boolean)isClientSide, (int)reactor.getFuelRodsCount());
        this._active = BooleanData.of((ModContainer)this, (boolean)isClientSide, () -> () -> ((MultiblockReactor)reactor).isMachineActive());
        this._wasteEjectionSetting = EnumData.of((ModContainer)this, (boolean)isClientSide, WasteEjectionSetting.class, () -> reactor::getWasteEjectionMode);
        this._coreHeat = DoubleData.sampled((int)3, (ModContainer)this, (boolean)isClientSide, () -> () -> reactor.getFuelHeat().getAsDouble());
        this._casingHeat = DoubleData.sampled((int)3, (ModContainer)this, (boolean)isClientSide, () -> () -> reactor.getReactorHeat().getAsDouble());
        this._fuelConsumedLastTick = FloatData.of((ModContainer)this, (boolean)isClientSide, () -> () -> Float.valueOf(reactor.getUiStats().getFuelConsumedLastTick()));
        this._fuelRichness = FloatData.sampled((int)3, (ModContainer)this, (boolean)isClientSide, () -> () -> Float.valueOf(reactor.getUiStats().getFuelRichness()));
        this._generatedLastTick = DoubleData.of((ModContainer)this, (boolean)isClientSide, () -> () -> reactor.getUiStats().getAmountGeneratedLastTick());
        this._energyStored = WideAmountData.sampled((int)3, (ModContainer)this, (boolean)isClientSide, () -> () -> reactor.getEnergyStored(this.getOutputEnergySystem()));
        this._fuelStack = reactor.getFuelContainer().getFuelStackData(2, (ModContainer)this, isClientSide);
        this._wasteStack = reactor.getFuelContainer().getWasteStackData(2, (ModContainer)this, isClientSide);
        this._coolantStack = reactor.getFluidContainer().getCoolantStackData(2, (ModContainer)this, isClientSide);
        this._vaporStack = reactor.getFluidContainer().getVaporStackData(2, (ModContainer)this, isClientSide);
    }

    public ReactorControllerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf networkData) {
        this(windowId, playerInventory, (ReactorControllerEntity)AbstractModBlockEntity.getGuiClientBlockEntity((FriendlyByteBuf)networkData));
    }

    @Override
    public OperationalMode getReactorMode() {
        return this._reactorMode;
    }

    @Override
    public EnergySystem getOutputEnergySystem() {
        return this._outputEnergySystem;
    }

    @Override
    public BooleanData active() {
        return this._active;
    }

    @Override
    public WideAmount energyCapacity() {
        return this._energyCapacity;
    }

    @Override
    public WideAmountData energyStored() {
        return this._energyStored;
    }

    @Override
    public DoubleData generatedLastTick() {
        return this._generatedLastTick;
    }

    @Override
    public FluidStackData coolantStack() {
        return this._coolantStack;
    }

    @Override
    public FluidStackData vaporStack() {
        return this._vaporStack;
    }

    @Override
    public DoubleData coreHeat() {
        return this._coreHeat;
    }

    @Override
    public DoubleData casingHeat() {
        return this._casingHeat;
    }

    @Override
    public FloatData fuelConsumedLastTick() {
        return this._fuelConsumedLastTick;
    }

    @Override
    public FloatData fuelRichness() {
        return this._fuelRichness;
    }

    @Override
    public IntData reactantCapacity() {
        return this._reactantCapacity;
    }

    @Override
    public ReactantStackData fuelStack() {
        return this._fuelStack;
    }

    @Override
    public ReactantStackData wasteStack() {
        return this._wasteStack;
    }

    @Override
    public EnumData<WasteEjectionSetting> wasteEjectionSetting() {
        return this._wasteEjectionSetting;
    }

    @Override
    public IntData fluidCapacity() {
        return this._fluidCapacity;
    }

    @Override
    public IntData fuelRodsCount() {
        return this._fuelRodsCount;
    }
}

