/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantStack;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class ReactantStackData
extends AbstractData<ReactantStack>
implements IContainerData {
    private ReactantStack _lastValue;
    private AbstractData<Integer> _amountData;

    public static ReactantStackData immutable(ModContainer container, boolean isClientSide, ReactantStack value) {
        return ReactantStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ReactantStack>>)((NonNullSupplier)() -> () -> value));
    }

    public static ReactantStackData empty(boolean isClientSide) {
        return isClientSide ? new ReactantStackData() : new ReactantStackData((NonNullSupplier<Supplier<ReactantStack>>)((NonNullSupplier)() -> () -> ReactantStack.EMPTY));
    }

    public static ReactantStackData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<ReactantStack>> serverSideGetter) {
        return ReactantStackData.of(container, isClientSide, (NonNullSupplier<Supplier<ReactantStack>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static ReactantStackData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<ReactantStack>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        ReactantStackData data = isClientSide ? new ReactantStackData() : new ReactantStackData(serverSideGetter);
        container.addBindableData((IBindableData)data);
        return data;
    }

    public IBindableData<Integer> amount() {
        if (null == this._amountData) {
            this._amountData = AbstractData.of((Object)0);
        }
        return this._amountData;
    }

    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        ReactantStack current = new ReactantStack((ReactantStack)this._getter.get());
        if (this._lastValue.isEmpty() && current.isEmpty()) {
            return null;
        }
        boolean equalReactant = this._lastValue.isReactantEqual(current);
        if (!equalReactant || current.getAmount() != this._lastValue.getAmount()) {
            this._lastValue = current;
            if (equalReactant) {
                return buffer -> {
                    buffer.writeByte(1);
                    buffer.writeInt(current.getAmount());
                };
            }
            return buffer -> {
                buffer.writeByte(0);
                current.writeTo((FriendlyByteBuf)buffer);
            };
        }
        return null;
    }

    public void readContainerData(FriendlyByteBuf dataSource) {
        switch (dataSource.readByte()) {
            case 0: {
                ReactantStack data = ReactantStack.createFrom(dataSource);
                this.notify(data);
                if (null == this._amountData) break;
                this._amountData.notify((Object)data.getAmount());
                break;
            }
            case 1: {
                if (null == this._amountData) break;
                this._amountData.notify((Object)dataSource.readInt());
            }
        }
    }

    @Nullable
    public ReactantStack defaultValue() {
        return ReactantStack.EMPTY;
    }

    private ReactantStackData() {
    }

    private ReactantStackData(NonNullSupplier<Supplier<ReactantStack>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = ReactantStack.EMPTY;
    }
}

