/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.module.CreativeTabHelper;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class DeferredRegistryHelper {
    private final String modId;
    private final HashMap<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> registries;
    private final CreativeTabHelper creativeTabHelper;

    public DeferredRegistryHelper(String modId) {
        this.modId = modId;
        this.registries = new HashMap();
        this.creativeTabHelper = new CreativeTabHelper();
    }

    public <T> DeferredRegister<T> addRegistry(ResourceKey<? extends Registry<T>> key) {
        DeferredRegister deferredRegister = DeferredRegister.create(key, (String)this.modId);
        deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.registries.put(key, deferredRegister);
        return deferredRegister;
    }

    private <T> RegistryObject<T> register(ResourceKey<? extends Registry<T>> key, String name, Supplier<T> object) {
        DeferredRegister<?> deferredRegister = this.registries.get(key);
        if (deferredRegister == null) {
            this.addRegistry(key);
            deferredRegister = this.registries.get(key);
        }
        return deferredRegister.register(name, object);
    }

    public <T> RegistryObject<T> registerGeneric(ResourceKey<? extends Registry<T>> key, String name, Supplier<T> object) {
        return this.register(key, name, object);
    }

    public RegistryObject<BlockEntityType<?>> registerBlockEntityType(String name, Supplier<BlockEntityType<?>> object) {
        ResourceKey key = ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey();
        DeferredRegister<?> deferredRegister = this.registries.get(key);
        if (deferredRegister == null) {
            this.addRegistry(key);
            deferredRegister = this.registries.get(key);
        }
        return deferredRegister.register(name, object);
    }

    public RegistryObject<EntityType<?>> registerEntityType(String name, Supplier<EntityType<?>> object) {
        ResourceKey key = ForgeRegistries.ENTITY_TYPES.getRegistryKey();
        DeferredRegister<?> deferredRegister = this.registries.get(key);
        if (deferredRegister == null) {
            this.addRegistry(key);
            deferredRegister = this.registries.get(key);
        }
        return deferredRegister.register(name, object);
    }

    public RegistryObject<Block> registerBlockWithItem(String name, Supplier<? extends BasicBlock> blockSupplier, @Nullable TitaniumTab tab) {
        RegistryObject<Block> blockRegistryObject = this.registerGeneric(ForgeRegistries.BLOCKS.getRegistryKey(), name, blockSupplier::get);
        this.registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), name, () -> {
            BlockItem item = new BlockItem((Block)blockRegistryObject.get(), new Item.Properties());
            if (tab != null) {
                tab.getTabList().add((Item)item);
            }
            return item;
        });
        return blockRegistryObject;
    }

    public RegistryObject<Block> registerBlockWithItem(String name, Supplier<? extends Block> blockSupplier, Function<RegistryObject<Block>, Supplier<Item>> itemSupplier, TitaniumTab tab) {
        RegistryObject<Block> block = this.registerGeneric(ForgeRegistries.BLOCKS.getRegistryKey(), name, blockSupplier::get);
        this.registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), name, () -> {
            Item item = (Item)((Supplier)itemSupplier.apply(block)).get();
            if (tab != null) {
                tab.getTabList().add(item);
            }
            return item;
        });
        return block;
    }

    public Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> registerBlockWithTile(String name, Supplier<BasicTileBlock<?>> blockSupplier, @Nullable TitaniumTab tab) {
        RegistryObject<Block> blockRegistryObject = this.registerBlockWithItem(name, blockSupplier, tab);
        return Pair.of(blockRegistryObject, this.registerBlockEntityType(name, () -> BlockEntityType.Builder.m_155273_(((BasicTileBlock)blockRegistryObject.get()).getTileEntityFactory(), (Block[])new Block[]{(Block)blockRegistryObject.get()}).m_58966_(null)));
    }

    public Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> registerBlockWithTileItem(String name, Supplier<BasicTileBlock<?>> blockSupplier, Function<RegistryObject<Block>, Supplier<Item>> itemSupplier, @Nullable TitaniumTab tab) {
        RegistryObject<Block> blockRegistryObject = this.registerBlockWithItem(name, blockSupplier, itemSupplier, tab);
        return Pair.of(blockRegistryObject, this.registerBlockEntityType(name, () -> BlockEntityType.Builder.m_155273_(((BasicTileBlock)blockRegistryObject.get()).getTileEntityFactory(), (Block[])new Block[]{(Block)blockRegistryObject.get()}).m_58966_(null)));
    }
}

