/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.reward.storage;

import com.hrznstudio.titanium.reward.storage.EnabledRewards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class RewardWorldStorage
extends SavedData {
    public static String NAME = "TitaniumReward";
    private HashMap<UUID, EnabledRewards> rewards = new HashMap();
    private List<ResourceLocation> freeRewards = new ArrayList<ResourceLocation>();
    private List<UUID> configuredPlayers = new ArrayList<UUID>();

    private RewardWorldStorage() {
    }

    public static RewardWorldStorage get(ServerLevel world) {
        return (RewardWorldStorage)world.m_8895_().m_164861_(compoundTag -> new RewardWorldStorage().load((CompoundTag)compoundTag), RewardWorldStorage::new, NAME);
    }

    public void remove(UUID uuid, ResourceLocation resourceLocation) {
        this.rewards.computeIfAbsent(uuid, uuid1 -> new EnabledRewards()).getEnabled().remove(resourceLocation);
    }

    public void add(UUID uuid, ResourceLocation resourceLocation, String option) {
        this.rewards.computeIfAbsent(uuid, uuid1 -> new EnabledRewards()).getEnabled().put(resourceLocation, option);
    }

    public void addFree(ResourceLocation resourceLocation) {
        this.freeRewards.add(resourceLocation);
    }

    public List<ResourceLocation> getFreeRewards() {
        return this.freeRewards;
    }

    public List<UUID> getConfiguredPlayers() {
        return this.configuredPlayers;
    }

    public RewardWorldStorage load(CompoundTag nbt) {
        CompoundTag compoundNBT = nbt.m_128469_(NAME);
        this.rewards.clear();
        compoundNBT.m_128431_().forEach(s -> {
            EnabledRewards rewards = new EnabledRewards();
            rewards.deserializeNBT(compoundNBT.m_128469_(s));
            this.rewards.put(UUID.fromString(s), rewards);
        });
        this.freeRewards.clear();
        CompoundTag free = nbt.m_128469_("FreeRewards");
        free.m_128431_().forEach(s -> this.freeRewards.add(new ResourceLocation(s)));
        this.configuredPlayers.clear();
        CompoundTag configured = nbt.m_128469_("ConfiguredPlayers");
        configured.m_128431_().forEach(s -> this.configuredPlayers.add(UUID.fromString(s)));
        return this;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag compoundNBT = new CompoundTag();
        this.rewards.forEach((uuid, enabledRewards) -> compoundNBT.m_128365_(uuid.toString(), (Tag)enabledRewards.serializeNBT()));
        compound.m_128365_(NAME, (Tag)compoundNBT);
        CompoundTag free = new CompoundTag();
        this.freeRewards.forEach(resourceLocation -> free.m_128379_(resourceLocation.toString(), true));
        compound.m_128365_("FreeRewards", (Tag)free);
        CompoundTag configured = new CompoundTag();
        this.configuredPlayers.forEach(uuid -> configured.m_128379_(uuid.toString(), true));
        compound.m_128365_("ConfiguredPlayers", (Tag)configured);
        return compound;
    }

    public CompoundTag serializeSimple() {
        CompoundTag compoundNBT = new CompoundTag();
        this.rewards.forEach((uuid, enabledRewards) -> compoundNBT.m_128365_(uuid.toString(), (Tag)enabledRewards.serializeNBT()));
        return compoundNBT;
    }
}

