/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.GemsBase;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.gems.world.OreConfigDefaults;
import org.jetbrains.annotations.NotNull;

public class WorldGenGenerator
extends DatapackBuiltinEntriesProvider {
    private static final RuleTest replaceStone = new TagMatchTest(BlockTags.f_144266_);
    private static final RuleTest replaceDeepslate = new TagMatchTest(BlockTags.f_144267_);
    private static final RuleTest replaceNetherrack = new TagMatchTest(Tags.Blocks.NETHERRACK);
    private static final RuleTest replaceEndStone = new TagMatchTest(Tags.Blocks.END_STONES);
    private static final ConfiguredFeature<?, ?> silverOre = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)replaceStone, (BlockState)GemsBlocks.SILVER_ORE.asBlockState()), (Object)OreConfiguration.m_161021_((RuleTest)replaceDeepslate, (BlockState)GemsBlocks.DEEPSLATE_SILVER_ORE.asBlockState())), 8, 0.2f));
    private static final Map<Gems, ConfiguredFeature<?, ?>> overworldOreFeatures = WorldGenGenerator.makeMap(g -> {
        OreConfigDefaults config = g.getOreConfigDefaults((ResourceKey<Level>)Level.f_46428_);
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)replaceStone, (BlockState)g.getOre().m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)replaceDeepslate, (BlockState)g.getDeepslateOre().m_49966_())), config.size(), config.discardChanceOnAirExposure()));
    });
    private static final Map<Gems, ConfiguredFeature<?, ?>> netherOreFeatures = WorldGenGenerator.makeMap(g -> {
        OreConfigDefaults config = g.getOreConfigDefaults((ResourceKey<Level>)Level.f_46429_);
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(replaceNetherrack, g.getNetherOre().m_49966_(), config.size(), config.discardChanceOnAirExposure()));
    });
    private static final Map<Gems, ConfiguredFeature<?, ?>> endOreFeatures = WorldGenGenerator.makeMap(g -> {
        OreConfigDefaults config = g.getOreConfigDefaults((ResourceKey<Level>)Level.f_46430_);
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(replaceEndStone, g.getEndOre().m_49966_(), config.size(), config.discardChanceOnAirExposure()));
    });
    private static final Map<Gems, ConfiguredFeature<?, ?>> overworldFlowerFeatures = WorldGenGenerator.makeMap(WorldGenGenerator::glowroses);
    private static final Map<Gems, ConfiguredFeature<?, ?>> netherFlowerFeatures = WorldGenGenerator.makeMap(WorldGenGenerator::glowroses);
    private static final Map<Gems, ConfiguredFeature<?, ?>> endFlowerFeatures = WorldGenGenerator.makeMap(WorldGenGenerator::glowroses);
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, ctx -> {
        ctx.m_255272_(WorldGenGenerator.configuredFeature(GemsBase.getId("overworld/silver_ore")), silverOre);
        overworldOreFeatures.forEach((gem, feature) -> ctx.m_255272_(WorldGenGenerator.getOreFeatureKey(gem, (ResourceKey<Level>)Level.f_46428_), feature));
        netherOreFeatures.forEach((gem, feature) -> ctx.m_255272_(WorldGenGenerator.getOreFeatureKey(gem, (ResourceKey<Level>)Level.f_46429_), feature));
        endOreFeatures.forEach((gem, feature) -> ctx.m_255272_(WorldGenGenerator.getOreFeatureKey(gem, (ResourceKey<Level>)Level.f_46430_), feature));
        overworldFlowerFeatures.forEach((gem, feature) -> ctx.m_255272_(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.f_46428_), feature));
        netherFlowerFeatures.forEach((gem, feature) -> ctx.m_255272_(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.f_46429_), feature));
        endFlowerFeatures.forEach((gem, feature) -> ctx.m_255272_(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.f_46430_), feature));
    }).m_254916_(Registries.f_256988_, ctx -> {
        ResourceKey<ConfiguredFeature<?, ?>> silverOreKey = WorldGenGenerator.configuredFeature(GemsBase.getId("overworld/silver_ore"));
        ctx.m_255272_(WorldGenGenerator.placedFeature(silverOreKey.m_135782_()), (Object)WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstapContext<PlacedFeature>)ctx, silverOreKey), -60, 40, 16));
        overworldOreFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedFeature((BootstapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.f_46428_));
        netherOreFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedFeature((BootstapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.f_46429_));
        endOreFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedFeature((BootstapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.f_46430_));
        overworldFlowerFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedGlowroseFeature((BootstapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.f_46428_));
        netherFlowerFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedGlowroseFeature((BootstapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.f_46429_));
        endFlowerFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedGlowroseFeature((BootstapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.f_46430_));
    }).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> {
        ArrayList overworldOthers = new ArrayList();
        ResourceKey<ConfiguredFeature<?, ?>> silverOreKey = WorldGenGenerator.configuredFeature(GemsBase.getId("overworld/silver_ore"));
        overworldOthers.add(silverOreKey);
        overworldFlowerFeatures.forEach((gem, feature) -> overworldOthers.add(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.f_46428_)));
        WorldGenGenerator.registerOreBiomeModifiers((BootstapContext<BiomeModifier>)ctx, (ResourceKey<Level>)Level.f_46428_, (TagKey<Biome>)BiomeTags.f_215817_, overworldOreFeatures, "overworld_features", overworldOthers);
        ArrayList netherOthers = new ArrayList();
        netherFlowerFeatures.forEach((gem, feature) -> netherOthers.add(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.f_46429_)));
        WorldGenGenerator.registerOreBiomeModifiers((BootstapContext<BiomeModifier>)ctx, (ResourceKey<Level>)Level.f_46429_, (TagKey<Biome>)BiomeTags.f_207612_, netherOreFeatures, "nether_features", netherOthers);
        ArrayList endOthers = new ArrayList();
        endFlowerFeatures.forEach((gem, feature) -> endOthers.add(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.f_46430_)));
        WorldGenGenerator.registerOreBiomeModifiers((BootstapContext<BiomeModifier>)ctx, (ResourceKey<Level>)Level.f_46430_, (TagKey<Biome>)BiomeTags.f_215818_, endOreFeatures, "end_features", endOthers);
    });

    public WorldGenGenerator(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), BUILDER, Collections.singleton("silentgems"));
    }

    public static <T> Map<Gems, T> makeMap(Function<Gems, T> getter) {
        LinkedHashMap<Gems, T> map = new LinkedHashMap<Gems, T>();
        for (Gems gem : Gems.values()) {
            map.put(gem, getter.apply(gem));
        }
        return map;
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> getOreFeatureKey(Gems gem, ResourceKey<Level> level) {
        return WorldGenGenerator.configuredFeature(GemsBase.getId(level.m_135782_().m_135815_() + "/" + gem.getName() + "_ore"));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> getGlowroseFeatureKey(Gems gem, ResourceKey<Level> level) {
        return WorldGenGenerator.configuredFeature(GemsBase.getId(level.m_135782_().m_135815_() + "/" + gem.getName() + "_glowrose"));
    }

    private static void makePlacedFeature(BootstapContext<PlacedFeature> ctx, Gems gem, ResourceKey<Level> level) {
        ResourceKey<ConfiguredFeature<?, ?>> key = WorldGenGenerator.getOreFeatureKey(gem, level);
        OreConfigDefaults config = gem.getOreConfigDefaults(level);
        PlacedFeature placed = WorldGenGenerator.placed(WorldGenGenerator.holderFeature(ctx, key), config.minHeight(), config.maxHeight(), config.count());
        ctx.m_255272_(WorldGenGenerator.placedFeature(key.m_135782_()), (Object)placed);
    }

    private static void makePlacedGlowroseFeature(BootstapContext<PlacedFeature> ctx, Gems gem, ResourceKey<Level> level) {
        ResourceKey<ConfiguredFeature<?, ?>> key = WorldGenGenerator.getGlowroseFeatureKey(gem, level);
        PlacedFeature placed = new PlacedFeature((Holder)ctx.m_255420_(Registries.f_256911_).m_255043_(key), (List)ImmutableList.of((Object)RarityFilter.m_191900_((int)256), (Object)InSquarePlacement.m_191715_(), (Object)HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING), (Object)BiomeFilter.m_191561_()));
        ctx.m_255272_(WorldGenGenerator.placedFeature(key.m_135782_()), (Object)placed);
    }

    private static void registerOreBiomeModifiers(BootstapContext<BiomeModifier> ctx, ResourceKey<Level> level, TagKey<Biome> biomes, Map<Gems, ConfiguredFeature<?, ?>> ores, String modifierName, Collection<ResourceKey<ConfiguredFeature<?, ?>>> others) {
        HolderSet.Named biomeTagSet = ctx.m_255420_(Registries.f_256952_).m_254956_(biomes);
        ArrayList list = new ArrayList();
        ores.forEach((gem, feature) -> {
            ResourceKey<ConfiguredFeature<?, ?>> key = WorldGenGenerator.getOreFeatureKey(gem, level);
            list.add(WorldGenGenerator.holderPlaced(ctx, key.m_135782_()));
        });
        others.forEach(o -> list.add(WorldGenGenerator.holderPlaced(ctx, o.m_135782_())));
        ForgeBiomeModifiers.AddFeaturesBiomeModifier oresMod = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeTagSet, (HolderSet)HolderSet.m_205800_(list), GenerationStep.Decoration.UNDERGROUND_ORES);
        ctx.m_255272_(WorldGenGenerator.biomeModifier(GemsBase.getId(modifierName)), (Object)oresMod);
    }

    @NotNull
    private static ConfiguredFeature<RandomPatchConfiguration, Feature<RandomPatchConfiguration>> glowroses(Gems g) {
        return new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(32, 7, 3, Holder.m_205709_((Object)new PlacedFeature(Holder.m_205709_((Object)new ConfiguredFeature(Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)g.getGlowrose())))), (List)ImmutableList.of((Object)BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.f_190393_))))));
    }

    public static ConfiguredFeature<?, ?> ore(Block block, RuleTest replacing, int size) {
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(replacing, block.m_49966_(), size));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeature(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)name);
    }

    protected static ResourceKey<PlacedFeature> placedFeature(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)name);
    }

    protected static ResourceKey<BiomeModifier> biomeModifier(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)name);
    }

    public static PlacedFeature placed(Holder<ConfiguredFeature<?, ?>> feature, int minHeight, int maxHeight, int count) {
        return new PlacedFeature(feature, WorldGenGenerator.placements(minHeight, maxHeight, count));
    }

    public static List<PlacementModifier> placements(int minHeight, int maxHeight, int count) {
        return ImmutableList.of((Object)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight)), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)count), (Object)BiomeFilter.m_191561_());
    }

    public static Holder<ConfiguredFeature<?, ?>> holderFeature(BootstapContext<PlacedFeature> ctx, ResourceKey<ConfiguredFeature<?, ?>> location) {
        return ctx.m_255420_(Registries.f_256911_).m_255043_(location);
    }

    public static Holder<PlacedFeature> holderPlaced(BootstapContext<BiomeModifier> ctx, ResourceLocation location) {
        return ctx.m_255420_(Registries.f_256988_).m_255043_(WorldGenGenerator.placedFeature(location));
    }
}

