/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.recipe;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.GemsTags;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.data.recipe.LibRecipeProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsRecipeProvider
extends LibRecipeProvider {
    public GemsRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn, "silentgems");
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.registerGemRecipes(consumer);
        this.registerMetals(consumer);
        this.registerFoods(consumer);
        this.registerMisc(consumer);
    }

    private void registerGemRecipes(Consumer<FinishedRecipe> consumer) {
        for (Gems gem : Gems.values()) {
            String name = gem.getName();
            this.smeltingAndBlastingRecipes(consumer, name, gem.getModOresItemTag(), (ItemLike)gem.getItem(), 1.0f);
            this.compressionRecipes(consumer, (ItemLike)gem.getBlock(), (ItemLike)gem.getItem(), null);
            this.shapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getBricks(), 12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), ItemTags.f_13169_).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(gem.getItemTag())).save(consumer);
            this.shapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getGlass(), 12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), Tags.Items.GLASS_COLORLESS).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(gem.getItemTag())).save(consumer);
            this.shapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getLamp(GemLampBlock.State.OFF)).pattern("rgr").pattern("gog").pattern("rgr").define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(gem.getItemTag())).save(consumer);
            this.shapelessBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getLamp(GemLampBlock.State.INVERTED_ON)).requires((ItemLike)gem.getLamp(GemLampBlock.State.OFF)).requires((ItemLike)Items.f_41978_).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(gem.getItemTag())).save(consumer);
        }
        this.glowroseToDye(consumer, Gems.RUBY, (ItemLike)Items.f_42497_);
        this.glowroseToDye(consumer, Gems.CARNELIAN, (ItemLike)Items.f_42497_);
        this.glowroseToDye(consumer, Gems.TOPAZ, (ItemLike)Items.f_42536_);
        this.glowroseToDye(consumer, Gems.CITRINE, (ItemLike)Items.f_42539_);
        this.glowroseToDye(consumer, Gems.HELIODOR, (ItemLike)Items.f_42539_);
        this.glowroseToDye(consumer, Gems.MOLDAVITE, (ItemLike)Items.f_42540_);
        this.glowroseToDye(consumer, Gems.PERIDOT, (ItemLike)Items.f_42496_);
        this.glowroseToDye(consumer, Gems.TURQUOISE, (ItemLike)Items.f_42492_);
        this.glowroseToDye(consumer, Gems.KYANITE, (ItemLike)Items.f_42538_);
        this.glowroseToDye(consumer, Gems.SAPPHIRE, (ItemLike)Items.f_42494_);
        this.glowroseToDye(consumer, Gems.IOLITE, (ItemLike)Items.f_42493_);
        this.glowroseToDye(consumer, Gems.ALEXANDRITE, (ItemLike)Items.f_42493_);
        this.glowroseToDye(consumer, Gems.AMMOLITE, (ItemLike)Items.f_42537_);
        this.glowroseToDye(consumer, Gems.ROSE_QUARTZ, (ItemLike)Items.f_42489_);
        this.glowroseToDye(consumer, Gems.BLACK_DIAMOND, (ItemLike)Items.f_42498_);
        this.glowroseToDye(consumer, Gems.WHITE_DIAMOND, (ItemLike)Items.f_42535_);
    }

    private void glowroseToDye(Consumer<FinishedRecipe> consumer, Gems gem, ItemLike dye) {
        String dyeName = NameUtils.fromItem((ItemLike)dye).m_135815_();
        String glowroseName = NameUtils.fromItem((ItemLike)gem.getGlowrose()).m_135815_();
        this.shapelessBuilder(RecipeCategory.MISC, dye, 1).requires(gem.getGlowroseItemTag()).save(consumer, this.modId(dyeName + "_from_" + glowroseName));
    }

    private void registerMetals(Consumer<FinishedRecipe> consumer) {
        this.smeltingAndBlastingRecipes(consumer, "silver_ingot", (ItemLike)GemsItems.RAW_SILVER.get(), (ItemLike)GemsItems.SILVER_INGOT.get(), 1.0f);
        this.compressionRecipes(consumer, (ItemLike)GemsBlocks.SILVER_BLOCK.get(), (ItemLike)GemsItems.SILVER_INGOT.get(), (ItemLike)GemsItems.SILVER_NUGGET.get());
    }

    private void registerFoods(Consumer<FinishedRecipe> consumer) {
        this.shapedBuilder(RecipeCategory.FOOD, (ItemLike)GemsItems.POTATO_ON_A_STICK).pattern(" p").pattern("/ ").define(Character.valueOf('p'), (ItemLike)Items.f_42674_).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_125977_((ItemLike)Items.f_42674_)).save(consumer);
        this.shapedBuilder(RecipeCategory.FOOD, (ItemLike)GemsItems.SUGAR_COOKIE, 8).pattern(" S ").pattern("///").pattern(" S ").define(Character.valueOf('S'), (ItemLike)Items.f_42501_).define(Character.valueOf('/'), (ItemLike)Items.f_42405_).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_125977_((ItemLike)Items.f_42501_)).save(consumer);
        this.shapedBuilder(RecipeCategory.FOOD, (ItemLike)GemsItems.IRON_POTATO).pattern("/#/").pattern("#p#").pattern("/#/").define(Character.valueOf('/'), Tags.Items.GEMS).define(Character.valueOf('#'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('p'), (ItemLike)Items.f_42620_).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_125977_((ItemLike)Items.f_42620_)).save(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, GemsItems.UNCOOKED_FISHY_STEW).m_126209_((ItemLike)Items.f_42399_).m_206419_(GemsTags.Items.STEW_FISH).m_126209_((ItemLike)Items.f_42576_).m_126209_((ItemLike)Items.f_41952_).m_126132_("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(GemsTags.Items.STEW_FISH)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, GemsItems.UNCOOKED_MEATY_STEW).m_126209_((ItemLike)Items.f_42399_).m_206419_(GemsTags.Items.STEW_MEAT).m_126209_((ItemLike)Items.f_42620_).m_126209_((ItemLike)Items.f_42619_).m_126132_("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(GemsTags.Items.STEW_MEAT)).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{GemsItems.UNCOOKED_FISHY_STEW}), (RecipeCategory)RecipeCategory.FOOD, GemsItems.FISHY_STEW, (float)0.45f, (int)200).m_126132_("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(GemsTags.Items.STEW_FISH)).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{GemsItems.UNCOOKED_MEATY_STEW}), (RecipeCategory)RecipeCategory.FOOD, GemsItems.MEATY_STEW, (float)0.45f, (int)200).m_126132_("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(GemsTags.Items.STEW_MEAT)).m_176498_(consumer);
    }

    private void registerMisc(Consumer<FinishedRecipe> consumer) {
        this.shapedBuilder(RecipeCategory.MISC, (ItemLike)GemsItems.GEM_BAG).pattern("/~/").pattern("#g#").pattern("###").define(Character.valueOf('~'), Tags.Items.STRING).define(Character.valueOf('/'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('#'), ItemTags.f_13167_).define(Character.valueOf('g'), Tags.Items.GEMS).save(consumer);
        this.shapedBuilder(RecipeCategory.MISC, (ItemLike)GemsItems.FLOWER_BASKET).pattern("/~/").pattern("#g#").pattern("###").define(Character.valueOf('~'), Tags.Items.STRING).define(Character.valueOf('/'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_, Items.f_41911_})).define(Character.valueOf('g'), GemsTags.Items.GLOWROSES).save(consumer);
        this.shapedBuilder(RecipeCategory.MISC, (ItemLike)GemsItems.SOUL_GEM).pattern(" g ").pattern("#d#").pattern(" o ").define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('o'), (ItemLike)Items.f_42730_).define(Character.valueOf('g'), GemsTags.Items.GEMS).define(Character.valueOf('#'), GemsTags.Items.INGOTS_SILVER).save(consumer);
        this.shapedBuilder(RecipeCategory.MISC, (ItemLike)GemsItems.SUMMON_KITTY).pattern("|f|").pattern("|g|").pattern("|f|").define(Character.valueOf('|'), Tags.Items.STRING).define(Character.valueOf('f'), GemsTags.Items.STEW_FISH).define(Character.valueOf('g'), GemsTags.Items.GEMS).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(GemsTags.Items.GEMS)).save(consumer);
        this.shapedBuilder(RecipeCategory.MISC, (ItemLike)GemsItems.SUMMON_PUPPY).pattern(" m ").pattern("#g#").pattern(" m ").define(Character.valueOf('m'), GemsTags.Items.STEW_FISH).define(Character.valueOf('#'), Tags.Items.LEATHER).define(Character.valueOf('g'), GemsTags.Items.GEMS).unlockedBy("has_item", (CriterionTriggerInstance)GemsRecipeProvider.m_206406_(GemsTags.Items.GEMS)).save(consumer);
    }
}

