/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.utils.Color;

public final class TextUtil {
    private final String modId;

    public TextUtil(String modId) {
        this.modId = modId;
    }

    public MutableComponent translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, this.modId, suffix);
        return Component.m_237110_((String)key, (Object[])params);
    }

    public MutableComponent misc(String suffix, Object ... params) {
        String key = String.format("misc.%s.%s", this.modId, suffix);
        return Component.m_237110_((String)key, (Object[])params);
    }

    public static MutableComponent itemSub(ItemLike item, String suffix, Object ... params) {
        String key = Util.m_137492_((String)"item", (ResourceLocation)NameUtils.fromItem((ItemLike)item));
        return Component.m_237110_((String)(key + "." + suffix), (Object[])params);
    }

    public static MutableComponent withColor(MutableComponent text, int color) {
        return text.m_130948_(text.m_7383_().m_131148_(TextColor.m_131266_((int)(color & 0xFFFFFF))));
    }

    public static MutableComponent withColor(MutableComponent text, Color color) {
        return TextUtil.withColor(text, color.getColor());
    }

    public static MutableComponent withColor(MutableComponent text, ChatFormatting color) {
        int colorCode = color.m_126665_() != null ? color.m_126665_() : 0xFFFFFF;
        return TextUtil.withColor(text, colorCode);
    }
}

