/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;

public class BlueprintEntityInfoTransformHandler {
    private static BlueprintEntityInfoTransformHandler ourInstance = new BlueprintEntityInfoTransformHandler();
    private Map<Predicate<CompoundTag>, Function<CompoundTag, CompoundTag>> entityInfoTransformHandler = new HashMap<Predicate<CompoundTag>, Function<CompoundTag, CompoundTag>>();

    public static BlueprintEntityInfoTransformHandler getInstance() {
        return ourInstance;
    }

    private BlueprintEntityInfoTransformHandler() {
    }

    public void AddTransformHandler(Predicate<CompoundTag> transformPredicate, Function<CompoundTag, CompoundTag> transformHandler) {
        this.entityInfoTransformHandler.put(transformPredicate, transformHandler);
    }

    public CompoundTag Transform(CompoundTag entityInfo) {
        return this.getTransformHandler(entityInfo).apply(entityInfo);
    }

    private Function<CompoundTag, CompoundTag> getTransformHandler(CompoundTag entityInfo) {
        return this.entityInfoTransformHandler.keySet().stream().filter(p -> p.test(entityInfo)).findFirst().map(p -> this.entityInfoTransformHandler.get(p)).orElse(Function.identity());
    }
}

