/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.client.BlueprintRenderer;
import com.ldtteam.structurize.client.RenderingCacheKey;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public final class BlueprintHandler {
    private static final BlueprintHandler ourInstance = new BlueprintHandler();
    public static final int CACHE_EXPIRE_SECONDS = 45;
    public static final int CACHE_EXPIRE_CHECK_SECONDS = 15;
    private final LoadingCache<RenderingCacheKey, BlueprintRenderer> rendererCache = CacheBuilder.newBuilder().expireAfterAccess(45L, TimeUnit.SECONDS).removalListener(entry -> ((BlueprintRenderer)entry.getValue()).close()).build((CacheLoader)new CacheLoader<RenderingCacheKey, BlueprintRenderer>(){

        public BlueprintRenderer load(RenderingCacheKey key) {
            return BlueprintRenderer.buildRendererForBlueprint(key.blueprint());
        }
    });

    private BlueprintHandler() {
    }

    public static BlueprintHandler getInstance() {
        return ourInstance;
    }

    public void draw(BlueprintPreviewData previewData, BlockPos pos, RenderLevelStageEvent ctx) {
        Vec3 viewPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        ctx.getPoseStack().m_85836_();
        ctx.getPoseStack().m_85837_(viewPosition.m_7096_(), viewPosition.m_7098_(), viewPosition.m_7094_());
        this.internalBackportDraw(previewData, pos, ctx);
        ctx.getPoseStack().m_85849_();
    }

    public void internalBackportDraw(BlueprintPreviewData previewData, BlockPos pos, RenderLevelStageEvent ctx) {
        if (previewData == null || previewData.getBlueprint() == null) {
            Log.getLogger().warn("Trying to draw null blueprint!");
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("struct_render_cache");
        ((BlueprintRenderer)this.rendererCache.getUnchecked((Object)previewData.getRenderKey())).draw(previewData, pos, ctx);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public void cleanCache() {
        this.rendererCache.cleanUp();
    }

    public void clearCache() {
        this.rendererCache.invalidateAll();
    }

    public void drawAtListOfPositions(BlueprintPreviewData previewData, List<BlockPos> points, RenderLevelStageEvent ctx) {
        if (points.isEmpty() || previewData == null || previewData.getBlueprint() == null) {
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("struct_render_multi");
        BlueprintRenderer renderer = (BlueprintRenderer)this.rendererCache.getUnchecked((Object)previewData.getRenderKey());
        Vec3 viewPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        ctx.getPoseStack().m_85836_();
        ctx.getPoseStack().m_85837_(viewPosition.m_7096_(), viewPosition.m_7098_(), viewPosition.m_7094_());
        for (BlockPos coord : points) {
            renderer.draw(previewData, coord, ctx);
        }
        ctx.getPoseStack().m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

