/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.ldtteam.structurize.util.LanguageHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.TickTask;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class AbstractConfiguration {
    private static final String DEFAULT_KEY_PREFIX = "structurize.config.default.";
    public static final String COMMENT_SUFFIX = ".comment";
    final List<ConfigWatcher<?>> watchers = new ArrayList();

    protected static void createCategory(ForgeConfigSpec.Builder builder, String key) {
        builder.comment(LanguageHandler.translateKey(AbstractConfiguration.commentTKey(key))).push(key);
    }

    protected static void swapToCategory(ForgeConfigSpec.Builder builder, String key) {
        AbstractConfiguration.finishCategory(builder);
        AbstractConfiguration.createCategory(builder, key);
    }

    protected static void finishCategory(ForgeConfigSpec.Builder builder) {
        builder.pop();
    }

    private static String nameTKey(String key) {
        return "structurize.config." + key;
    }

    private static String commentTKey(String key) {
        return AbstractConfiguration.nameTKey(key) + COMMENT_SUFFIX;
    }

    private static ForgeConfigSpec.Builder buildBase(ForgeConfigSpec.Builder builder, String key, String defaultDesc) {
        return builder.comment(LanguageHandler.translateKey(AbstractConfiguration.commentTKey(key)) + " " + defaultDesc).translation(AbstractConfiguration.nameTKey(key));
    }

    private static String translate(String key, Object ... args) {
        return LanguageHandler.translateKey(key).formatted(args);
    }

    protected static ForgeConfigSpec.BooleanValue defineBoolean(ForgeConfigSpec.Builder builder, String key, boolean defaultValue) {
        return AbstractConfiguration.buildBase(builder, key, AbstractConfiguration.translate("structurize.config.default.boolean", defaultValue)).define(key, defaultValue);
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue) {
        return AbstractConfiguration.defineInteger(builder, key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue, int min, int max) {
        return AbstractConfiguration.buildBase(builder, key, AbstractConfiguration.translate("structurize.config.default.number", defaultValue, min, max)).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.ConfigValue<String> defineString(ForgeConfigSpec.Builder builder, String key, String defaultValue) {
        return AbstractConfiguration.buildBase(builder, key, AbstractConfiguration.translate("structurize.config.default.string", defaultValue)).define(key, (Object)defaultValue);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue) {
        return AbstractConfiguration.defineLong(builder, key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue, long min, long max) {
        return AbstractConfiguration.buildBase(builder, key, AbstractConfiguration.translate("structurize.config.default.number", defaultValue, min, max)).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue) {
        return AbstractConfiguration.defineDouble(builder, key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue, double min, double max) {
        return AbstractConfiguration.buildBase(builder, key, AbstractConfiguration.translate("structurize.config.default.number", defaultValue, min, max)).defineInRange(key, defaultValue, min, max);
    }

    protected static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineList(ForgeConfigSpec.Builder builder, String key, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return AbstractConfiguration.buildBase(builder, key, "").defineList(key, defaultValue, elementValidator);
    }

    protected static <V extends Enum<V>> ForgeConfigSpec.EnumValue<V> defineEnum(ForgeConfigSpec.Builder builder, String key, V defaultValue) {
        return AbstractConfiguration.buildBase(builder, key, AbstractConfiguration.translate("structurize.config.default.enum", defaultValue, Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).map(Enum::name).collect(Collectors.joining(", ")))).defineEnum(key, defaultValue);
    }

    protected <T> void addWatcher(ForgeConfigSpec.ConfigValue<T> configValue, ConfigListener<T> listener) {
        this.watchers.add(new ConfigWatcher<T>(listener, configValue));
    }

    protected void addWatcher(Runnable listener, ForgeConfigSpec.ConfigValue<?> ... configValues) {
        ConfigListener<Object> typedListener = (o, n) -> listener.run();
        for (ForgeConfigSpec.ConfigValue<?> c : configValues) {
            this.watchers.add(new ConfigWatcher<Object>(typedListener, c));
        }
    }

    static class ConfigWatcher<T> {
        private final ConfigListener<T> listener;
        private final ForgeConfigSpec.ConfigValue<T> forgeConfig;
        private T lastValue;

        private ConfigWatcher(ConfigListener<T> listener, ForgeConfigSpec.ConfigValue<T> forgeConfig) {
            this.listener = listener;
            this.forgeConfig = forgeConfig;
        }

        boolean sameForgeConfig(ForgeConfigSpec.ConfigValue<?> other) {
            return other == this.forgeConfig;
        }

        synchronized void cacheLastValue() {
            this.lastValue = this.forgeConfig.get();
        }

        synchronized void compareAndFireChangeEvent() {
            Object newValue = this.forgeConfig.get();
            if (!newValue.equals(this.lastValue)) {
                ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(FMLEnvironment.dist.isClient() ? LogicalSide.CLIENT : LogicalSide.SERVER)).m_6937_((Runnable)new TickTask(0, () -> this.listener.onChange(this.lastValue, newValue)));
                this.lastValue = newValue;
            }
        }
    }

    @FunctionalInterface
    public static interface ConfigListener<T> {
        public void onChange(T var1, T var2);
    }
}

