/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.items.ItemTagSubstitution;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbsorbBlockMessage
implements IMessage {
    private final BlockPos pos;
    private final ItemStack stack;

    public AbsorbBlockMessage(@NotNull BlockPos pos, @NotNull ItemStack stack) {
        this.pos = pos;
        this.stack = stack;
    }

    public AbsorbBlockMessage(@NotNull FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.stack = buf.m_130267_();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeItemStack(this.stack, false);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(@NotNull NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        ItemStack current = player.m_150109_().m_36056_();
        Item item = current.m_41720_();
        if (item instanceof ItemTagSubstitution) {
            ItemTagSubstitution anchor = (ItemTagSubstitution)item;
            anchor.onAbsorbBlock(player, current, this.pos, this.stack);
        }
    }
}

