/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.util.Log;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class IOPool {
    private static final BlockingQueue<Runnable> ioQueue = new LinkedBlockingDeque<Runnable>();
    private static ThreadPoolExecutor executor;

    public static ThreadPoolExecutor getExecutor() {
        if (executor == null) {
            executor = new ThreadPoolExecutor(1, 2, 10L, TimeUnit.SECONDS, ioQueue, new StructurizeThreadFactory());
        }
        return executor;
    }

    public static void shutdown() {
        IOPool.getExecutor().shutdownNow();
        ioQueue.clear();
        executor = null;
    }

    private IOPool() {
    }

    public static <T> Future<T> submit(@NotNull Callable<T> task) {
        return IOPool.getExecutor().submit(task);
    }

    public static void execute(@NotNull Runnable task) {
        IOPool.getExecutor().execute(task);
    }

    public static class StructurizeThreadFactory
    implements ThreadFactory {
        public static int id;

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread = new Thread(runnable, "Structurize IO Worker #" + id++);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((thread1, throwable) -> Log.getLogger().error("Structurize IO Thread errored! ", throwable));
            return thread;
        }
    }
}

