/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;

public class BarsPanel
extends AbstractControlContainer {
    public BarsPanel(ModContainerScreen<? extends ModContainer> gui, String name) {
        this(gui, name, 84);
    }

    public BarsPanel(ModContainerScreen<? extends ModContainer> gui, String name, int height) {
        super(gui, name);
        this.setBarsHeight(height);
        this.setDesiredDimension(DesiredDimension.Width, 0);
        this.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
    }

    public BarsPanel add(IControl control) {
        this.addControl(control);
        this.addWidth(control);
        return this;
    }

    public BarsPanel addTemperatureScale() {
        Panel control = CommonPanels.verticalTemperatureScale(this.getGui(), this.getBarsHeight());
        this.addChildControl((IControl)control);
        this.addWidth(control);
        return this;
    }

    public BarsPanel addVerticalSeparator() {
        Panel control = CommonPanels.verticalSeparator(this.getGui(), this.getBarsHeight());
        this.addChildControl((IControl)control);
        this.addWidth(control);
        return this;
    }

    public BarsPanel addEmptyPanel(int width) {
        this.addChildControl((IControl)CommonPanels.empty(this.getGui(), width, this.getBarsHeight()));
        this.addWidth(width);
        return this;
    }

    private int getBarsHeight() {
        return this.getDesiredDimension(DesiredDimension.Height);
    }

    private void setBarsHeight(int height) {
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height must be greater than zero.");
        this.setDesiredDimension(DesiredDimension.Height, height);
    }

    private void addWidth(int width) {
        this.setDesiredDimension(DesiredDimension.Width, this.getDesiredDimension(DesiredDimension.Width) + width);
    }

    private void addWidth(IControl control) {
        this.addWidth(control.getDesiredDimension(DesiredDimension.Width));
    }
}

