/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControl;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.ItemStackData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullConsumer;

public class ItemStackDisplay
extends AbstractControl {
    private ItemStack _stack;
    private NonNullConsumer<GuiGraphics> _painter;

    public ItemStackDisplay(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
        this.setDesiredDimension(18, 18);
        this.setPadding(1);
        this.setStack(ItemStack.f_41583_);
    }

    public ItemStackDisplay(ModContainerScreen<? extends ModContainer> gui) {
        this(gui, gui.nextGenericName());
    }

    public void setStack(ItemStack stack) {
        this._stack = stack.m_41777_();
        this.onStackChanged();
    }

    public void setStackAmount(int amount) {
        if (amount <= 0) {
            this.setStack(ItemStack.f_41583_);
        } else {
            this._stack.m_41764_(amount);
        }
        this.onStackChanged();
    }

    public void bindStack(ItemStackData bindableStack) {
        bindableStack.bind(this::setStack);
        bindableStack.amount().bind(this::setStackAmount);
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this._painter.accept((Object)gfx);
    }

    private void onStackChanged() {
        if (this._stack.m_41619_()) {
            this._painter = this::paintWithNoCount;
            this.clearTooltips();
        } else {
            this._painter = this._stack.m_41613_() > 1 ? this::paintWithCount : this::paintWithNoCount;
            this.setTooltips(new Component[]{TextHelper.literal("%dx ", this._stack.m_41613_()).m_7220_((Component)TextHelper.translatable(this._stack.m_41778_()).m_130940_(ChatFormatting.BOLD))});
        }
    }

    private void paintWithNoCount(GuiGraphics matrix) {
        this.paintItemStack(matrix, this._stack, false);
    }

    private void paintWithCount(GuiGraphics matrix) {
        this.paintItemStackWithCount(matrix, this._stack, false);
    }
}

