/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public class AnchoredLayoutEngine
extends AbstractLayoutEngine<AnchoredLayoutEngine> {
    @Override
    public void layout(IControlContainer controlsContainer) {
        Rectangle parentBounds = controlsContainer.getBounds();
        int horizontalMargin = this.getHorizontalMargin();
        int verticalMargin = this.getVerticalMargin();
        int defaultWidth = this.computeDefaultValueForUndefinedDimension(controlsContainer, DesiredDimension.Width, parentBounds.Width);
        int defaultHeight = this.computeDefaultValueForUndefinedDimension(controlsContainer, DesiredDimension.Height, parentBounds.Height);
        int bandMaxWidth = parentBounds.Width - horizontalMargin * 2;
        int bandMaxHeight = parentBounds.Height - verticalMargin * 2;
        for (IControl control : controlsContainer) {
            int controlWidth = Math.min(bandMaxWidth, this.getControlDesiredDimension(control, DesiredDimension.Width, defaultWidth));
            int controlHeight = Math.min(bandMaxHeight, this.getControlDesiredDimension(control, DesiredDimension.Height, defaultHeight));
            control.setBounds(switch (this.getAnchorFrom(control)) {
                case Anchor.Top -> new Rectangle((bandMaxWidth - controlWidth) / 2, verticalMargin, controlWidth, controlHeight);
                case Anchor.Bottom -> new Rectangle((bandMaxWidth - controlWidth) / 2, parentBounds.Height - controlHeight - verticalMargin, controlWidth, controlHeight);
                case Anchor.Left -> new Rectangle(horizontalMargin, verticalMargin, controlWidth, bandMaxHeight);
                case Anchor.Right -> new Rectangle(parentBounds.Width - controlWidth - horizontalMargin, verticalMargin, controlWidth, bandMaxHeight);
                case Anchor.TopLeft -> new Rectangle(horizontalMargin, verticalMargin, controlWidth, controlHeight);
                case Anchor.TopRight -> new Rectangle(parentBounds.Width - controlWidth - horizontalMargin, verticalMargin, controlWidth, controlHeight);
                case Anchor.BottomLeft -> new Rectangle(horizontalMargin, parentBounds.Height - controlHeight - verticalMargin, controlWidth, controlHeight);
                case Anchor.BottomRight -> new Rectangle(parentBounds.Width - controlWidth - horizontalMargin, parentBounds.Height - controlHeight - verticalMargin, controlWidth, controlHeight);
                case Anchor.Center -> new Rectangle((bandMaxWidth - controlWidth) / 2, (bandMaxHeight - controlHeight) / 2 - 1, controlWidth, controlHeight);
                default -> throw new IllegalArgumentException("Unknown anchor");
            });
        }
    }

    private Anchor getAnchorFrom(IControl control) {
        return control.getLayoutEngineHint().filter(h -> h instanceof Anchor).map(h -> (Anchor)h).orElse(Anchor.TopLeft);
    }

    public static enum Anchor implements ILayoutEngine.ILayoutEngineHint
    {
        Left,
        Right,
        Top,
        Bottom,
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight,
        Center;

    }
}

