/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.zerono.mods.zerocore.internal.client.RenderTypes;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;

public abstract class FluidTankRenderer {
    private static final float MARGIN = 0.005f;
    protected final int _capacity;

    protected FluidTankRenderer(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Capacity must be greater than zero");
        this._capacity = capacity;
    }

    private static float[] computeQuadCoordinates(int steps) {
        return FluidTankRenderer.computeQuadCoordinates(steps, 1.0f, 0.005f, (float)steps - 0.005f);
    }

    private static float[] computeQuadCoordinates(int steps, float stepSize, float start, float end) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0, (Object)"Steps must be greater than zero");
        float[] coords = new float[1 + steps];
        int offset = (int)start;
        coords[0] = start;
        for (int i = 1; i <= steps - 1; ++i) {
            coords[i] = (float)i * stepSize + (float)offset;
        }
        coords[coords.length - 1] = end;
        return coords;
    }

    public static class Single
    extends FluidTankRenderer {
        private final int _xSteps;
        private final float[] _xQuadCoords;
        private final int _ySteps;
        private final float[] _yQuadCoords;
        private final int _zSteps;
        private final float[] _zQuadCoords;

        public Single(int capacity, float x1, float y1, float z1, float x2, float y2, float z2) {
            super(capacity);
            this._xSteps = (int)(x2 - x1) + 1;
            this._xQuadCoords = FluidTankRenderer.computeQuadCoordinates(this._xSteps);
            this._ySteps = (int)(y2 - y1) + 1;
            this._yQuadCoords = FluidTankRenderer.computeQuadCoordinates(this._ySteps);
            this._zSteps = (int)(z2 - z1) + 1;
            this._zQuadCoords = FluidTankRenderer.computeQuadCoordinates(this._zSteps);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, FluidStack fluidStack) {
            int x;
            int z;
            float y2;
            float incompleteSpriteMaxV;
            float incompleteSpriteMinV;
            float flowingSpriteMaxV;
            float flowingSpriteMinV;
            float stillSpriteMaxV;
            float stillSpriteMinV;
            if (fluidStack.isEmpty()) {
                return;
            }
            float fillPercentage = Math.min(1.0f, (float)fluidStack.getAmount() / (float)this._capacity);
            float yFilledSteps = (float)this._ySteps * fillPercentage;
            int yFullSteps = (int)yFilledSteps;
            float yIncompleteStepPercentage = yFilledSteps - (float)yFullSteps;
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderTypes.FLUID_COLUMN);
            Fluid fluid = fluidStack.getFluid();
            FluidType fluidType = fluid.getFluidType();
            TextureAtlasSprite stillSprite = ModRenderHelper.getFluidStillSprite(fluid);
            TextureAtlasSprite flowingSprite = ModRenderHelper.getFluidFlowingSprite(fluid);
            int fluidColour = ModRenderHelper.getFluidTint(fluid);
            float stillSpriteMinU = stillSprite.m_118409_();
            float stillSpriteMaxU = stillSprite.m_118410_();
            float flowingSpriteMinU = flowingSprite.m_118409_();
            float flowingSpriteMaxU = flowingSprite.m_118410_();
            if (fluidType.isLighterThanAir()) {
                stillSpriteMinV = stillSprite.m_118412_();
                stillSpriteMaxV = stillSprite.m_118411_();
                flowingSpriteMinV = flowingSprite.m_118412_();
                flowingSpriteMaxV = flowingSprite.m_118411_();
                if (yIncompleteStepPercentage > 0.0f) {
                    incompleteSpriteMinV = flowingSprite.m_118393_(16.0 * (double)yIncompleteStepPercentage);
                    incompleteSpriteMaxV = flowingSprite.m_118411_();
                } else {
                    incompleteSpriteMaxV = 0.0f;
                    incompleteSpriteMinV = 0.0f;
                }
            } else {
                stillSpriteMinV = stillSprite.m_118411_();
                stillSpriteMaxV = stillSprite.m_118412_();
                flowingSpriteMinV = flowingSprite.m_118411_();
                flowingSpriteMaxV = flowingSprite.m_118412_();
                if (yIncompleteStepPercentage > 0.0f) {
                    incompleteSpriteMinV = flowingSprite.m_118393_(16.0 * (1.0 - (double)yIncompleteStepPercentage));
                    incompleteSpriteMaxV = flowingSprite.m_118412_();
                } else {
                    incompleteSpriteMaxV = 0.0f;
                    incompleteSpriteMinV = 0.0f;
                }
            }
            packedLight = ModRenderHelper.addBlockLight(packedLight, fluidType.getLightLevel(fluidStack));
            float y1 = y2 = this._yQuadCoords[0] + 0.005f;
            for (z = 0; z < this._zSteps; ++z) {
                for (x = 0; x < this._xSteps; ++x) {
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.DOWN, this._xQuadCoords[x], y1, this._zQuadCoords[z], this._xQuadCoords[x + 1], y1, this._zQuadCoords[z + 1], stillSpriteMinU, stillSpriteMaxU, stillSpriteMinV, stillSpriteMaxV, fluidColour, packedLight);
                }
            }
            for (int yStep = 0; yStep < yFullSteps; ++yStep) {
                y1 = this._yQuadCoords[yStep];
                y2 = this._yQuadCoords[yStep + 1];
                for (x = 0; x < this._xSteps; ++x) {
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.NORTH, this._xQuadCoords[x], y1, this._zQuadCoords[0], this._xQuadCoords[x + 1], y2, this._zQuadCoords[1], flowingSpriteMinU, flowingSpriteMaxU, flowingSpriteMinV, flowingSpriteMaxV, fluidColour, packedLight);
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.SOUTH, this._xQuadCoords[x], y1, this._zQuadCoords[this._zSteps - 1], this._xQuadCoords[x + 1], y2, this._zQuadCoords[this._zSteps], flowingSpriteMinU, flowingSpriteMaxU, flowingSpriteMinV, flowingSpriteMaxV, fluidColour, packedLight);
                }
                for (int z2 = 0; z2 < this._zSteps; ++z2) {
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.WEST, this._xQuadCoords[0], y1, this._zQuadCoords[z2], this._xQuadCoords[1], y2, this._zQuadCoords[z2 + 1], flowingSpriteMinU, flowingSpriteMaxU, flowingSpriteMinV, flowingSpriteMaxV, fluidColour, packedLight);
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.EAST, this._xQuadCoords[this._xSteps - 1], y1, this._zQuadCoords[z2], this._xQuadCoords[this._xSteps], y2, this._zQuadCoords[z2 + 1], flowingSpriteMinU, flowingSpriteMaxU, flowingSpriteMinV, flowingSpriteMaxV, fluidColour, packedLight);
                }
            }
            if (yIncompleteStepPercentage > 0.0f) {
                y1 = y2;
                y2 = y1 + yIncompleteStepPercentage;
                for (int x2 = 0; x2 < this._xSteps; ++x2) {
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.NORTH, this._xQuadCoords[x2], y1, this._zQuadCoords[0], this._xQuadCoords[x2 + 1], y2, this._zQuadCoords[1], flowingSpriteMinU, flowingSpriteMaxU, incompleteSpriteMinV, incompleteSpriteMaxV, fluidColour, packedLight);
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.SOUTH, this._xQuadCoords[x2], y1, this._zQuadCoords[this._zSteps - 1], this._xQuadCoords[x2 + 1], y2, this._zQuadCoords[this._zSteps], flowingSpriteMinU, flowingSpriteMaxU, incompleteSpriteMinV, incompleteSpriteMaxV, fluidColour, packedLight);
                }
                for (z = 0; z < this._zSteps; ++z) {
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.WEST, this._xQuadCoords[0], y1, this._zQuadCoords[z], this._xQuadCoords[1], y2, this._zQuadCoords[z + 1], flowingSpriteMinU, flowingSpriteMaxU, incompleteSpriteMinV, incompleteSpriteMaxV, fluidColour, packedLight);
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.EAST, this._xQuadCoords[this._xSteps - 1], y1, this._zQuadCoords[z], this._xQuadCoords[this._xSteps], y2, this._zQuadCoords[z + 1], flowingSpriteMinU, flowingSpriteMaxU, incompleteSpriteMinV, incompleteSpriteMaxV, fluidColour, packedLight);
                }
            }
            for (z = 0; z < this._zSteps; ++z) {
                for (x = 0; x < this._xSteps; ++x) {
                    ModRenderHelper.renderBlockFace(vertexConsumer, matrix, Direction.UP, this._xQuadCoords[x], y1, this._zQuadCoords[z], this._xQuadCoords[x + 1], y2, this._zQuadCoords[z + 1], stillSpriteMinU, stillSpriteMaxU, stillSpriteMinV, stillSpriteMaxV, fluidColour, packedLight);
                }
            }
        }
    }
}

